/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ListContentCommand.java,v 1.3 2006/04/06 15:28:01 samwai Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file.dynamic;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.FileIdentifierList;

/**
 * The list content command is a specialized abstract file inspection command
 * that operates on the operands listing theri content and returning it back to
 * the client
 * 
 * @author Scott E. Schneider
 */
class ListContentCommand extends AbstractFileInspectionCommand implements IListContentCommand {

	/**
	 * Constructs a list content command given remote identifier operands and a
	 * progress monitor
	 * 
	 * @param context
	 *            the context this command is executing within
	 * @param remoteIdentifiers
	 *            operands to list the content of (typically a directory or
	 *            folder that would have contents to list)
	 * @param monitor
	 *            the progress monitor to report progress on or cancel
	 *            progression of
	 */
	ListContentCommand(String context, FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
		super(context, ListContentCommand.class);
	}

}
