/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISocketChannel.java,v 1.1 2005/09/21 20:51:31 sschneid Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file.socket;

import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

/**
 * An abstraction above the socket channel to allow a socket channel to be
 * emulated by taking a readable byte channel and a writeable byte channel and
 * combining them into a new interface. Socket channel is a class and not an
 * interface in Java, so this interface is introduced to satisfy our purposes.
 * 
 * The file transfer service will work with this socket channel interface
 * instead of directing using Java's standard socket channel class.
 * 
 * @author Scott E. Schneider
 */
public interface ISocketChannel extends Channel, ReadableByteChannel, WritableByteChannel {
	/**
	 * Returns the underlying socket associated with this channel
	 * 
	 * @return the socket associated with this channel
	 */
	public Socket getSocket();
}