/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISocketChannelFactory.java,v 1.1 2007/04/09 14:04:26 samwai Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.execution.core.file.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

/**
 * The socket channel factory creates socket channel objects given some seed information such as socket, real channel or connection information to establish a new socket channel.
 * 
 * @author Scott E. Schneider
 */
public interface ISocketChannelFactory {
	/**
	 * Creates a local socket channel abstraction over a new socket to be established at the given internet socket address, basically connects to the address given, establishes a socket to the other side and returns back an abstraction to manipulate the connection with -- this method creates a new connection at the given address or returns back an existing connection that is not in use (with no contention with another client possible)
	 * 
	 * @param address
	 *            the address to establish a connection to
	 * @return a new socket channel to use
	 * @throws IOException
	 *             throws an IO exception if socket problems arise
	 */
	public ISocketChannel create(InetSocketAddress address) throws IOException;

	/**
	 * Creates a local socket channel abstraction over a new socket to be established at the given internet socket address, basically connects to the address given, establishes a socket to the other side and returns back an abstraction to manipulate the connection with -- this method creates a new connection at the given address or returns back an existing connection that is not in use (with no contention with another client possible)
	 * 
	 * @param address
	 *            the address to establish a connection to
	 * @param timeout
	 *            timeout to use for the connection
	 * @return a new socket channel to use
	 * @throws IOException
	 *             throws an IO exception if socket problems arise
	 */
	public ISocketChannel create(InetSocketAddress address, int timeout) throws IOException;

	/**
	 * Creates a local socket channel abstraction for the given standard channel, this does not create a new connection, simply wraps a java.nio channel with a local abstraction
	 * 
	 * @param realChannel
	 *            the standard Java abstraction
	 * @return the local socket channel interface, abstracting the real socket channel and associated socket
	 */
	public ISocketChannel create(java.nio.channels.SocketChannel realChannel);

	/**
	 * Creates a local socket channel abstraction for the given socket, this does not create a new connection, simply wraps a java.nio channel with a local abstraction
	 * 
	 * @param socket
	 *            the socket to seed this socket channel
	 * @return the local socket channel interface abstacting an already existing socket
	 * @throws an
	 *             IO exception if socket problems arise
	 */
	public ISocketChannel create(Socket socket) throws IOException;
}
