/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FileServiceConstants.java,v 1.1 2007/04/09 14:04:26 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.file;

/**
 * @author Giridhar.S
 * 
 * This interface defines constants required for implementing file service.
 * 
 */
public interface FileServiceConstants {

	public final static int RA_BUFFER_SIZE = 1024;

	/* The static return values for possible exceptions we may have to catch */

	public static final int RA_ERROR = -1;
	public static final int SECURE_CONNECTION_REQUIRED_EXCEPTION = -2;
	public static final int UNTRUSTED_AGENT_CONTROLLER_EXCEPTION = -3;
	public static final int AGENT_CONTROLLER_UNAVAILABLE_EXCEPTION = -4;
	public static final int LOGIN_FAILED_EXCEPTION = -5;
	public static final int UNKNOWN_HOST_EXCEPTION = -6;
	public static final int CONNECT_EXCEPTION = -7;
	public final static int RA_FILE_NOT_FOUND_ERROR = -8;
	public final static int RA_IO_ERROR = -9;
	public final static int RA_BIND_EXCEPTION = -10;

	/* Values to represent the state of the file server */
	public final static int RA_FS_STATUS_OK = 0;
	public final static int RA_FS_STATUS_ERROR = -1;

	/* Values to represent the initialization status of the file server */
	public final static int RA_FS_UNINITIALIZED = 0;
	public final static int RA_FS_INITIALIZED = 1;
}
