/*******************************************************************************
 * Copyright (c) 2005 2008 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommunicationDebug.java,v 1.9 2008/03/20 18:49:50 dmorris Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.execution.local;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author slavescu
 */
public class CommunicationDebug {
	public boolean debug = false;
	public boolean debugMessageValue = false;
	public boolean debugUseOldDataServer = false;
	public boolean debugSocketInputStream = false;
	public boolean debugUseEventMode = false;

	protected String plugin_name; 
	protected String value; 

	public static CommunicationDebug INSTANCE = new CommunicationDebug("org.eclipse.hyades.execution");//$NON-NLS-1$
	private Map binaryLogs = new HashMap();

	public CommunicationDebug(String plugin_name) {
		this.plugin_name = plugin_name;
		init();
	}

	protected void init() {
		try {
			value = getPlatformDebugOption(plugin_name+"/debug");//$NON-NLS-1$
			if (value != null) {
				debug = value.equalsIgnoreCase("true");//$NON-NLS-1$
			}
			else
				if(System.getProperty("CommunicationDebug.debug")!=null)//$NON-NLS-1$
				{
					debug = Boolean.valueOf(System.getProperty("CommunicationDebug.debug")).booleanValue();//$NON-NLS-1$
				}
			
			value = getPlatformDebugOption(plugin_name+"/debug/messageValue");//$NON-NLS-1$
			if (value != null) {
				debugMessageValue = value.equalsIgnoreCase("true");//$NON-NLS-1$
			}
			else
				if(System.getProperty("CommunicationDebug.debugMessageValue")!=null)//$NON-NLS-1$
				{
					debugMessageValue = Boolean.valueOf(System.getProperty("CommunicationDebug.debugMessageValue")).booleanValue();//$NON-NLS-1$
				}
			value = getPlatformDebugOption(plugin_name+"/debug/useOldDataServer");//$NON-NLS-1$
			if (value != null) {
				debugUseOldDataServer = value.equalsIgnoreCase("true");//$NON-NLS-1$
			}
			else
				if(System.getProperty("CommunicationDebug.debugUseOldDataServer")!=null)//$NON-NLS-1$
				{
					debugUseOldDataServer = Boolean.valueOf(System.getProperty("CommunicationDebug.debugUseOldDataServer")).booleanValue();//$NON-NLS-1$
				}
			value = getPlatformDebugOption(plugin_name+"/debug/socketInputStream");//$NON-NLS-1$
			if (value != null) {
				debugSocketInputStream = value.equalsIgnoreCase("true");//$NON-NLS-1$
			}
			else
				if(System.getProperty("CommunicationDebug.debugSocketInputStream")!=null)//$NON-NLS-1$
				{
					debugSocketInputStream = Boolean.valueOf(System.getProperty("CommunicationDebug.debugSocketInputStream")).booleanValue();//$NON-NLS-1$
				}
			value = getPlatformDebugOption(plugin_name+"/debug/useEventMode");//$NON-NLS-1$
			if (value != null) {
				debugUseEventMode = value.equalsIgnoreCase("true");//$NON-NLS-1$
			}
			else
				if(System.getProperty("CommunicationDebug.debugUseEventMode")!=null)//$NON-NLS-1$
				{
					debugUseEventMode = Boolean.valueOf(System.getProperty("CommunicationDebug.debugUseEventMode")).booleanValue();//$NON-NLS-1$
				}
		} catch (Exception e) {
			// the platform is not available so it needs to be set directly
		}
	}

	protected String getPlatformDebugOption(String option) {
			if(option==null)
				return null;
	        try {
	            Class platform = Class.forName("org.eclipse.core.runtime.Platform");//$NON-NLS-1$
	            Method getDebugOption = platform.getMethod("getDebugOption", new Class[]{String.class});//$NON-NLS-1$
	            String value = (String)getDebugOption.invoke(null, new String[]{option});

	            return value;
	        } catch (Exception e) {
	            return null;
	        }
	}
	
    public static String makeUTF8String(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }

        try {
            return new String(data, offset, length, "UTF8");//$NON-NLS-1$
        }
        catch (Exception ex) {
            return null;
        }
    }
    
    public synchronized int writeBinaryLog(String id, byte[] buffer, int offset,int length)
    {
    	int real_length = Math.min(length,buffer.length-offset);
    	if(real_length>0)
    	{
    		FileOutputStream f = getBinaryLog(id);
    		if(f!=null)
    		{
	    		try {
					f.write(buffer,offset,real_length);
					f.flush();
				} catch (IOException e) {
					if(debug)
						e.printStackTrace();
				}
    		}
    	}
    	return real_length;
    }

	public synchronized FileOutputStream getBinaryLog(String id) {
		FileOutputStream f = (FileOutputStream)binaryLogs.get(id);
		if(f==null)
		{
			try {
				f = new FileOutputStream("/"+id+"-"+(new Date()).getTime());
				binaryLogs.put(id,f);
			} catch (FileNotFoundException e) {
				if(debug)
					e.printStackTrace();
			}
		}
		else
		{
			if(!f.getChannel().isOpen())
			{
				try {
					f = new FileOutputStream("/"+id+"-"+(new Date()).getTime());
					binaryLogs.put(id,f);
				} catch (FileNotFoundException e) {
					if(debug)
						e.printStackTrace();
				}
			}
		}
		return f;
	}
	public synchronized FileOutputStream removeBinaryLog(String id) {
		FileOutputStream f = (FileOutputStream)binaryLogs.get(id);
		if(f!=null)
		{
			if(f.getChannel().isOpen())
			{
				try {
					f.close();
				} catch (Exception e) {
					if(debug)
						e.printStackTrace();
				}
			}
			binaryLogs.remove(id);
		}
		return f;
	}
	
}