/**********************************************************************
 * Copyright (c) 2005 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionEnvironmentStub.java,v 1.3 2008/03/20 18:49:50 dmorris Exp $
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;

/**
 * @author ddreakfo
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ExecutionEnvironmentStub extends ExecutionComponentStub implements IExecutionEnvironment {
	
	public ExecutionEnvironmentStub() {
		super();
	}
	
	public ExecutionEnvironmentStub(IExecutionComponent delegate) {
		super(delegate);
	}

	/**
	 * This implementation returns the remote execution environment. The remote
	 * environment is the important one; that is where execution takes place.
	 * 
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#getEnv()
	 */
	public IOrderedProperty[] getEnv() throws ExecutionComponentStateException {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getEnv");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (IOrderedProperty[])rtnValue;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#getEnvByName(java.lang.String)
	 */
	public IOrderedProperty getEnvByName(String name) throws ExecutionComponentStateException {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{name}, "getEnvByName");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (IOrderedProperty)rtnValue;
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#setEnv(org.eclipse.hyades.execution.core.IOrderedProperty[])
	 */
	public void setEnv(IOrderedProperty[] env)	throws ExecutionComponentStateException {
		
		// Make the change locally, also. This shouldn't be necessary, but a bug
		// in another part of our infrastructure can be worked around if we set
		// the value locally, as well as remotely.
		((IExecutionEnvironment)delegate).setEnv(env);
		
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{IOrderedProperty[].class}, new Object[]{env}, "setEnv");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#addEnv(org.eclipse.hyades.execution.core.IOrderedProperty)
	 */
	public void addEnv(IOrderedProperty env) throws ExecutionComponentStateException {
		// Make the change locally, also. This shouldn't be necessary, but a bug
		// in another part of our infrastructure can be worked around if we set
		// the value locally, as well as remotely.
		((IExecutionEnvironment)delegate).addEnv(env);
		
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{IOrderedProperty.class}, new Object[]{env}, "addEnv");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#removeProperty(java.lang.String)
	 */
	public IOrderedProperty removeProperty(String name)	throws ExecutionComponentStateException {
		// Make the change locally, also. This shouldn't be necessary, but a bug
		// in another part of our infrastructure can be worked around if we set
		// the value locally, as well as remotely.
		((IExecutionEnvironment)delegate).removeProperty(name);

		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{name}, "removeProperty");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (IOrderedProperty)rtnValue;
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#setEnv(org.eclipse.hyades.execution.core.IOrderedProperty)
	 */
	public void setEnv(IOrderedProperty env) throws ExecutionComponentStateException {
		((IExecutionEnvironment)delegate).setEnv(env);

		ReturnData invokeRtn = delegateRemoteCall(new Class[]{IOrderedProperty.class}, new Object[]{env}, "setEnv");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		
	}

}
