/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesTestNodeImpl.java,v 1.3 2005/05/20 22:53:09 jptoomey Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.local;

import java.net.UnknownHostException;
import java.security.Principal;

import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;

/**
 * This class extends the default NodeImpl class by overriding the connect
 * method.
 */
public class HyadesTestNodeImpl extends NodeImpl {

    /**
     * Constructs a new hyades test node implementation
     * 
     * @param name
     *            name of this node implementation
     */
    public HyadesTestNodeImpl(String name) {
        super(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.execution.core.INode#connect(java.lang.String,
     *      java.security.Principal)
     */
    public ISession connect(final String daemonType, final Principal principal) throws UnknownDaemonException,
            DaemonConnectException, UnknownHostException {

        /*
         * This code previously implemented a session cache, removed due to
         * session JVM zombies -- session is released when finished at the end
         * of the test execution harness launch execution method.
         */
        return super.connect(daemonType, principal);

    }

}