/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaProcessExecutableObjectStub.java,v 1.3 2008/03/20 18:49:50 dmorris Exp $
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local;

import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;

/**
 * @author rduggan
 */
public class JavaProcessExecutableObjectStub extends ExecutableObjectStub {

	public void setArgs(String args) {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{args}, "setArgs");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}
	
	public String getArgs() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getArgs");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}
	
	public void setExe(String exe) {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{exe}, "setExe");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	public String getExe() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getExe");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}
	
	public void setLocation(String loc) {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{loc}, "setLocation");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	public String getLocation() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getLocation");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}

	public void setAgentData(String data) {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{String.class}, new Object[]{data}, "setAgentData");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}

	public String getAgentData() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getAgentData");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}
	
	public String getCommandLine() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getCommandLine");//$NON-NLS-1$
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}
}
