
/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaProcessExecutorStub.java,v 1.5 2008/03/20 18:49:50 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local;


import java.util.Enumeration;

import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.local.internal.resources.LocalResourceBundle;
import org.eclipse.hyades.execution.local.testservices.TestServiceAgentListener;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;

public class JavaProcessExecutorStub extends ExecutorStub {
	
	
	
	public void launch() throws ExecutionComponentStateException {
		/* Launch the process */
		super.launch();
		
		int trialCount=60;
		
		/* Get the process ID of the new process */
		String pid=getPid();
		
		/* Create a process model and agent for the other side */
		try {
			boolean found=false;
			Node node=((SessionStub)getSessionContext()).getAgent().getProcess().getNode();
			
			while(!found && trialCount>0) 
			{
				Enumeration processes=node.listProcesses();
				
				while(processes.hasMoreElements()) {
					Process proc=(Process)processes.nextElement();
					if(proc.getProcessId().equals(pid)) {
						
						found=true;
						synchronized(proc) {
							Enumeration agents=proc.getAgentsByType("tester");//$NON-NLS-1$
							while(agents.hasMoreElements()) 
							{
								Agent agent=(Agent)agents.nextElement();
								try 
								{
									
									// TODO JPT: Add additional agent listener here for
									// handling script service calls
									
									agent.addAgentListener(new AgentListener() 
									{

										public void error(Agent agent, String errorId, String errorMessage) 
										{
										}

										public void handleCommand(Agent agent, CommandElement command) {
											if(command instanceof CustomCommand) {
												// Handle the Stop message by firing a state change event
												// to notify interested observers that the agent has stopped.
												String commandData=((CustomCommand)command).getData();
												if ( commandData.equals(IControlMessage.STOP))
												{
													IRemoteHyadesComponent comp = findRemoteHyadesComponent();
													if ( comp != null )
													{
														comp.fireStateChangeEvent(new ExecutionComponentStateChangeEvent(comp, IExecutionComponent.DEAD));
													}
												}
											}
										}

										public void agentActive(Agent agent) {
										}

										public void agentInactive(Agent agent) {	
										}									
									});
									
									agent.addAgentListener(new TestServiceAgentListener());
									agent.attach();
									
									/* Find our RemoteHyadesComponent and set the agent */
									IExecutionComponent[] children=getChildren();
									for (int i=0; i<children.length;i++) {
										if(children[i] instanceof IRemoteHyadesComponent) {
											((JavaTaskRemoteHyadesComponentStub)children[i]).setAgent(agent);
										}
									}

									
									try
									{
										IExecutableObject executableObject = getExecutableObject();
										if(executableObject instanceof JavaProcessExecutableObjectStub)
										{
											String script = ((JavaProcessExecutableObjectStub)executableObject).getAgentData();
											if(script != null)
											{
												BinaryCustomCommand agentData = new BinaryCustomCommand();
												agentData.setData(script.getBytes("UTF-8"));//$NON-NLS-1$
												agent.invokeCustomCommand(agentData);
											}
										}
									}
									catch(Exception e1)
									{
										e1.printStackTrace();
									}
									
//									CustomCommand resumeCommand=new CustomCommand();
//									resumeCommand.setData(IControlMessage.START);
//									agent.invokeCustomCommand(resumeCommand);
								}
								catch(InactiveAgentException e) {
									
								}
								
							}
						}
					}
					try {
						Thread.sleep(1000);	
					}
					catch(InterruptedException e) {
					}
					trialCount--;
				}
			}
			
		}
		catch(InactiveProcessException e) {
			/* We can ignore this as our process is running */
		}
		catch(NotConnectedException e) {
			/* Wecan ignore this as we are connected */
		}
		
		if ( trialCount == 0 )
		{
			throw new ExecutionComponentStateException(IExecutionComponent.SUSPENDED, LocalResourceBundle.JavaProcessExecutorStub_UNABLE_FIND_CONTROL_AGENT_);
		}
		else
		{
			fireStateChangeEvent(new ExecutionComponentStateChangeEvent(this, IExecutionComponent.READY));
		}
		
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#supportsControlEvent(java.lang.String)
	 */
	public boolean supportsControlEvent(String controlEvent) {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#performControlEvent(java.lang.String)
	 */
	public String performControlEvent(String controlEvent, String[] params) {
		return "";
	}
	
	private IRemoteHyadesComponent findRemoteHyadesComponent()
	{
		IRemoteHyadesComponent comp = null;
		IExecutionComponent[] children=getChildren();
		for (int i=0; i<children.length;i++) {
			if(children[i] instanceof IRemoteHyadesComponent) {
				comp = (IRemoteHyadesComponent) children[i];
			}
		}
		return comp;
	}

}
