/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaTaskExecutableObjectStub.java,v 1.3 2008/03/20 18:49:50 dmorris Exp $
 *
 * Contributors:
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local;

import org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;

/**
 * Provide remote invocation semantics for <code>JavaTaskExecutableObject</code>s.
 */
public class JavaTaskExecutableObjectStub
	extends ExecutableObjectStub
	implements IJavaTaskExecutableObject {

	/**
	 * This operation is performed on the remote side.
	 * 
	 * @see org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject#run()
	 */
	public void run() {
		ReturnData rtnData = delegateRemoteCall(
			new Class[]{},
			new Object[]{},
			"run");//$NON-NLS-1$
		if ( rtnData.isError() )
			throw new RemoteInvocationException((Throwable)rtnData.getReturnValue());
	}

	/**
	 * @see org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject#start()
	 */
	public void start() {
		ReturnData rtnData = delegateRemoteCall(
			new Class[]{},
			new Object[]{},
			"start");//$NON-NLS-1$
		if ( rtnData.isError() )
			throw new RemoteInvocationException((Throwable)rtnData.getReturnValue());
	}

	/**
	 * @see org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject#stop()
	 */
	public void stop() {
		ReturnData rtnData = delegateRemoteCall(
			new Class[]{},
			new Object[]{},
			"stop");//$NON-NLS-1$
		if ( rtnData.isError() )
			throw new RemoteInvocationException((Throwable)rtnData.getReturnValue());
	}

}
