/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SessionContext.java,v 1.2 2005/02/25 22:17:09 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.local;

import java.security.Principal;

/**
 * This class is used by SessionContextToSessionMap, HyadesSessionImpl and 
 * TestExecutionHarness to facilitate reuse of Sessions.  
 * */
public class SessionContext {
	private String machine;
	private String daemonType; // port
	private Principal principal;

	/**
	 * 
	 */
	public SessionContext(
		String machine,
		String daemonType,
		Principal principal) {
		super();
		// TODO Auto-generated constructor stub
		setPrincipal(principal);
		setMachine(machine);
		setDaemonType(daemonType);
	}

	/**
	 * @return
	 */
	public String getDaemonType() {
		return daemonType;
	}

	/**
	 * @return
	 */
	public String getMachine() {
		return machine;
	}

	/**
	 * @return
	 */
	public Principal getPrincipal() {
		return principal;
	}

	/**
	 * @param string
	 */
	public void setDaemonType(String string) {
		daemonType = string;
	}

	/**
	 * @param string
	 */
	public void setMachine(String string) {
		machine = string;
	}

	/**
	 * @param principal
	 */
	public void setPrincipal(Principal principal) {
		this.principal = principal;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object arg0) {
		SessionContext context = (SessionContext) arg0;
		if (context == null) {
			return false;
		}

		String machine = context.getMachine();
		if (machine == null && getMachine() != null) {
			return false;
		} else if (machine != null) {
			if (!machine.equals(getMachine())) {
				return false;
			}
		}
		String daemonType = context.getDaemonType();
		if (daemonType == null && getDaemonType() != null) {
			return false;
		} else if (daemonType != null) {
			if (!daemonType.equals(getDaemonType())) {
				return false;
			}
		}

		Principal principal = context.getPrincipal();
		if (principal == null && getPrincipal() != null) {
			return false;
		} else if (principal != null) {
			if (!principal.equals(getPrincipal())) {
				return false;
			}
		}
		return true;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		// TODO Auto-generated method stub
		return (getMachine() + getDaemonType() + getPrincipal()).hashCode();
	}

}
