package org.eclipse.hyades.execution.local;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SessionImpl.java,v 1.3 2005/06/19 20:05:32 sschneid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;

public class SessionImpl extends ExecutionComponentImpl implements ISession {
	protected INode node;
	protected Agent agent;
	private AgentListener listener;

	public SessionImpl(INode node, Agent agent) {
		super();  
		this.node=node;
		this.agent=agent;
		this.listener = new AgentListener() {

			public void agentActive(Agent agent) {
				/* Notify our listeners that the state has changed */
				fireStateChangeEvent(new ExecutionComponentStateChangeEvent(SessionImpl.this, READY));
			}

			public void agentInactive(Agent agent) {
				/* Notify our listeners that the state has changed */
				fireStateChangeEvent(new ExecutionComponentStateChangeEvent(SessionImpl.this, DEAD));
			}

			public void error(Agent agent, String errorId, String errorMessage) {
				// TODO Auto-generated method stub
			
			}

			public void handleCommand(Agent agent, CommandElement command) {
				if(command instanceof CustomCommand) {
					CustomCommand custom=(CustomCommand)command;
					try {
						ReturnData returnVal=Marshaller.unmarshalReturnValue(custom.getDataBinary());
						
						Marshaller.queueReturnValue(returnVal);
					}
					catch(Throwable e) {
						e.printStackTrace();
					}
					
				}
			
			}	
		};
		createAgentListener();
	}
	
	public void release() {
	}
	
	public void removeListener() {
		if ( this.agent != null ) {
			this.agent.removeAgentListener(listener);
		}
	}
	
	/**
	 * We need to be able to navigate back to our node.
	 * 
	 */
	public INode getNode() {
		return this.node;
	}	
	
	/**
	 * This creates a agent listener for the embedded agent on the remote session.  
	 * This listener is responsible for firing state change events and forwarding 
	 * all the commands to the proper handler.
	 *
	 */
	private void createAgentListener() {
	
		this.agent.addAgentListener(this.listener);
	
	}
	
	public void invokeRemote(CustomCommand command) {
		try {
			this.agent.invokeCustomCommand(command);
		}
		catch(InactiveAgentException e) {
		    throw new RemoteInvocationException(e);
		}
	}
	
	public Agent getAgent() {
		return this.agent;
	}
}
