/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentScopingInformationCommand.java,v 1.3 2008/03/24 15:47:59 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

public class AgentScopingInformationCommand extends CommandElement implements Constants {
	private long processId;
	private long messageProcessId;
	private RAString processUUID = new RAString();
	private RAString agentName = new RAString();
	private RAString agentUUID = new RAString();
	private RAString agentType = new RAString();
	private RAString nodeUUID = new RAString();

	public AgentScopingInformationCommand() {
		_tag = Constants.RA_AGENT_SCOPING_INFORMATION;
	}

	public int getSize() {
		int size = 0;

		size += super.getSize();

		size += sizeofLong; // processId
		if (System.getProperty("os.name").startsWith("Linux")) {//$NON-NLS-1$
			size += sizeofLong; // messageProcessId;
		}
		size += processUUID.getSize();
		size += agentName.getSize();
		size += agentUUID.getSize();
		size += agentType.getSize();
		size += nodeUUID.getSize();

		return size;
	}

	/**
	 * Read the buffer to populate the class content. No need to read the tag
	 * since it is already being read by the handler
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.readFromBuffer(buffer, current);

		processId = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		if (System.getProperty("os.name").startsWith("Linux")) {//$NON-NLS-1$
			messageProcessId = Message.readRALongFromBuffer(buffer, current);
			current += sizeofLong;
		}

		current = Message.readRAStringFromBuffer(buffer, current, processUUID);
		current = Message.readRAStringFromBuffer(buffer, current, agentName);
		current = Message.readRAStringFromBuffer(buffer, current, agentUUID);
		current = Message.readRAStringFromBuffer(buffer, current, agentType);
		current = Message.readRAStringFromBuffer(buffer, current, nodeUUID);

		return current;
	}

	/**
	 * Need to write the class content to the buffer, that includes the tag as
	 * well
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.writeToBuffer(buffer, current);
		current = Message.writeRALongToBuffer(buffer, current, processId);

		if (System.getProperty("os.name").startsWith("Linux")) {//$NON-NLS-1$
			current = Message.writeRALongToBuffer(buffer, current, messageProcessId);
		}

		current = Message.writeRAStringToBuffer(buffer, current, processUUID);
		current = Message.writeRAStringToBuffer(buffer, current, agentName);
		current = Message.writeRAStringToBuffer(buffer, current, agentUUID);
		current = Message.writeRAStringToBuffer(buffer, current, agentType);
		current = Message.writeRAStringToBuffer(buffer, current, nodeUUID);

		return current;
	}

	public RAString getAgentName() {
		return agentName;
	}

	public void setAgentName(RAString agentName) {
		this.agentName = agentName;
	}

	public RAString getAgentType() {
		return agentType;
	}

	public void setAgentType(RAString agentType) {
		this.agentType = agentType;
	}

	public RAString getAgentUUID() {
		return agentUUID;
	}

	public void setAgentUUID(RAString agentUUID) {
		this.agentUUID = agentUUID;
	}

	public long getMessageProcessId() {
		return messageProcessId;
	}

	public void setMessageProcessId(long messageProcessId) {
		this.messageProcessId = messageProcessId;
	}

	public RAString getNodeUUID() {
		return nodeUUID;
	}

	public void setNodeUUID(RAString nodeUUID) {
		this.nodeUUID = nodeUUID;
	}

	public long getProcessId() {
		return processId;
	}

	public void setProcessId(long processId) {
		this.processId = processId;
	}

	public RAString getProcessUUID() {
		return processUUID;
	}

	public void setProcessUUID(RAString processUUID) {
		this.processUUID = processUUID;
	}

}
