/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AuthenticationSuccessfulCommand.java,v 1.1 2007/04/09 14:04:25 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

public class AuthenticationSuccessfulCommand extends CommandElement implements Constants {
	private RAString _key = new RAString("");

	public AuthenticationSuccessfulCommand() {
		super();
		_tag = RA_AUTHENTICATION_SUCCESSFUL;
	}

	public int getSize() {
		int size = super.getSize();

		size += _key.getSize();

		return size;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		/*
		 * Cannot call super.readFromBuffer() since this command does not have a
		 * context
		 */
		// current = super.readFromBuffer(buffer, current);
		current = Message.readRAStringFromBuffer(buffer, current, _key);

		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		/*
		 * Cannot call super.writeToBuffer() since this command does not have a
		 * context
		 */
		// current = super.writeToBuffer(buffer, current);
		current = Message.writeRALongToBuffer(buffer, current, _tag);
		current = Message.writeRAStringToBuffer(buffer, current, _key);

		return current;
	}

}
