/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CustomCommand.java,v 1.2 2008/03/20 18:49:51 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

public class CustomCommand extends SimpleAgentInfoCommand {

	public static final String ENCODING = "UTF-8";//$NON-NLS-1$
	protected RAString _data = null;
	protected RABinaryArray _binaryData = null;

	/**
	 * CustomCommand constructor comment.
	 */
	public CustomCommand() {
		super();
		_tag = RA_CUSTOM_COMMAND;
	}

	/**
	 * Insert the method's description here. Creation date: (2/20/01 11:23:17
	 * PM)
	 * 
	 * @return java.lang.String
	 */
	public String getData() {
		if (_data != null) {
			return _data.getData();
		} else if (_binaryData != null) {
			/*
			 * bugzilla 70251 - string data is send over the wire in UTF-8 so
			 * read bytes as UTF-8
			 */
			try {
				return new String(_binaryData.getData(), ENCODING);
			} catch (Exception e) {
				return new String(_binaryData.getData());
			}
		}
		return null;
	}

	public byte[] getDataBinary() {
		if (_binaryData != null) {
			return _binaryData.getData();
		} else if (_data != null) {
			try {
				return _data.getData().getBytes(ENCODING);
			} catch (Exception e) {
			}
		}
		return null;
	}

	/**
	 * getSize method comment.
	 */
	public int getSize() {
		if (_data != null) {
			return super.getSize() + _data.getSize();
		} else if (_binaryData != null) {
			return super.getSize() + _binaryData.getSize();
		}
		/* If neither of these are set, the minimum size is sizeofLong */
		return super.getSize() + sizeofLong;
	}

	/**
	 * readFromBuffer method comment.
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current = super.readFromBuffer(buffer, offset);
		_binaryData = new RABinaryArray();
		current = Message.readRABinaryArrayFromBuffer(buffer, current, _binaryData);
		return current;
	}

	/**
	 * Insert the method's description here. Creation date: (11/2/00 8:20:52 PM)
	 * 
	 * @param data
	 *            java.lang.String
	 */
	public void setData(String data) {
		if (_data == null) {
			_data = new RAString(data);
		} else {
			_data.setData(data);
		}
		_binaryData = null;

	}

	public void setData(byte[] data) {
		if (_binaryData == null) {
			_binaryData = new RABinaryArray(data);
		} else {
			_binaryData.setData(data);
		}
		_data = null;
	}

	/**
	 * writeToBuffer method comment.
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current;
		if (_data != null) {
			current = super.writeToBuffer(buffer, offset);
			current = Message.writeRAStringToBuffer(buffer, current, _data);
		} else if (_binaryData != null) {
			// By eliminating the change to the tag, the command type will
			// remain unchanged, causing encoding problems
			// on platforms such as the 390 if custom commands are used
			// inproperly as binary custom commands.
			// _tag=RA_BINARY_CUSTOM_COMMAND;
			current = super.writeToBuffer(buffer, offset);
			current = Message.writeRABinaryArrayToBuffer(buffer, current, _binaryData);
		} else {
			current = super.writeToBuffer(buffer, offset);
			current = Message.writeRAStringToBuffer(buffer, current, new RAString(""));
		}
		return current;
	}
}
