/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DetailedAgentInfoCommand.java,v 1.1 2007/04/09 14:04:25 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

public abstract class DetailedAgentInfoCommand extends DetailedProcessCommand implements Constants {
	protected RAString _agentName = new RAString("");
	protected RAString _agentUUID = new RAString("");
	protected RAString _agentType = new RAString("");

	/**
	 * ProcessInfoCommandEntry constructor comment.
	 */
	public DetailedAgentInfoCommand() {
		super();
	}

	public String getAgentName() {
		if (_agentName != null)
			return _agentName.getData();
		return null;
	}

	public void setAgentName(String name) {
		_agentName = new RAString(name);
	}

	public String getAgentType() {
		if (_agentType != null) {
			return _agentType.getData();
		}
		return null;
	}

	public void setAgentType(String type) {
		_agentType = new RAString(type);
	}

	public String getAgentUUID() {
		if (_agentUUID != null) {
			return _agentUUID.getData();
		}
		return null;
	}

	public void setAgentUUID(String uuid) {
		_agentUUID = new RAString(uuid);
	}

	public int getSize() {
		return super.getSize() + _agentName.getSize() + _agentUUID.getSize() + _agentType.getSize();
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = super.readFromBuffer(buffer, offset);
		current = Message.readRAStringFromBuffer(buffer, current, _agentName);
		current = Message.readRAStringFromBuffer(buffer, current, _agentUUID);
		current = Message.readRAStringFromBuffer(buffer, current, _agentType);
		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = super.writeToBuffer(buffer, offset);

		current = Message.writeRAStringToBuffer(buffer, current, _agentName);
		current = Message.writeRAStringToBuffer(buffer, current, _agentUUID);
		current = Message.writeRAStringToBuffer(buffer, current, _agentType);

		return current;
	}
}
