/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ErrorCommand.java,v 1.1 2007/04/09 14:04:24 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

public class ErrorCommand extends SimpleAgentInfoCommand implements Constants {

	protected long _severity;

	protected RAString _errorId = new RAString("");

	protected RAString _errorString = new RAString("");

	/**
	 * ErrorCommand constructor comment.
	 */
	public ErrorCommand() {
		super();
		_tag = RA_ERROR_STRING;
	}

	public String getErrorId() {
		return _errorId._data;
	}

	public String getErrorString() {
		return _errorString._data;
	}

	public long getSeverity() {
		return _severity;
	}

	/**
	 * getSize method comment.
	 */
	public int getSize() {
		int size = super.getSize();
		size += sizeofLong;
		size += _errorId.getSize();
		size += _errorString.getSize();
		return size;
	}

	/**
	 * readFromBuffer method comment.
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current = super.readFromBuffer(buffer, offset);
		_severity = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;
		current = Message.readRAStringFromBuffer(buffer, current, _errorId);
		current = Message.readRAStringFromBuffer(buffer, current, _errorString);
		return current;
	}

	public void setErrorId(String id) {
		_errorId = new RAString(id);
	}

	public void setErrorString(String s) {
		_errorString = new RAString(s);
	}

	public void setSeverity(long sev) {
		_severity = sev;
	}

	/**
	 * writeToBuffer method comment.
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current = super.writeToBuffer(buffer, offset);
		current = Message.writeRALongToBuffer(buffer, current, _severity);
		current = Message.writeRAStringToBuffer(buffer, current, _errorId);
		current = Message.writeRAStringToBuffer(buffer, current, _errorString);
		return current;
	}
}
