/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExtendedDataServerListener.java,v 1.1 2007/04/09 14:04:23 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

import java.io.InputStream;

public interface ExtendedDataServerListener extends DataServerListener {
	/**
	 * @param buffer
	 *            byte[]
	 * @param length
	 *            int
	 * @param peer
	 *            java.net.InetAddress
	 */
	void incommingData(byte[] buffer, int offset, int length, java.net.InetAddress peer);

	/**
	 * @param buffer
	 *            char[]
	 * @param length
	 *            int
	 * @param peer
	 *            java.net.InetAddress
	 */
	void incommingData(char[] buffer, int offset, int length, java.net.InetAddress peer);

	/**
	 * @param data
	 *            byte[]
	 * @param length
	 *            int
	 * @param peer
	 *            java.net.InetAddress
	 */
	void invalidDataType(byte[] data, int offset, int length, java.net.InetAddress peer);

	void incommingStream(InputStream inputStream, java.net.InetAddress peer);
}
