/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GetPropertyListCommand.java,v 1.1 2007/04/09 14:04:24 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

public class GetPropertyListCommand extends CommandElement implements Constants {
	private RAString name = null;
	private RAString type = null;
	private RAString agentUUID = new RAString("");

	public GetPropertyListCommand() {
		super();
		_tag = RA_GET_PROPERTY_LIST;
	}

	public void setName(String str) {
		name = new RAString(str);
	}

	public RAString getName() {
		return name;
	}

	public void setType(String str) {
		type = new RAString(str);
	}

	public RAString getType() {
		return type;
	}

	public void setAgentUUID(String str) {
		agentUUID = new RAString(str);
	}

	public RAString getAgentUUID() {
		return agentUUID;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.readFromBuffer(buffer, current);
		current = Message.readRAStringFromBuffer(buffer, current, name);
		current = Message.readRAStringFromBuffer(buffer, current, type);
		current = Message.readRAStringFromBuffer(buffer, current, agentUUID);

		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.writeToBuffer(buffer, current);
		current = Message.writeRAStringToBuffer(buffer, current, name);
		current = Message.writeRAStringToBuffer(buffer, current, type);
		current = Message.writeRAStringToBuffer(buffer, current, agentUUID);

		return current;
	}

	public int getSize() {
		int size = super.getSize();

		size += name.getSize();
		size += type.getSize();
		size += agentUUID.getSize();

		return size;
	}

}
