/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LaunchProcessCommand.java,v 1.1 2007/04/09 14:04:24 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

import java.util.Vector;

public class LaunchProcessCommand extends CommandElement implements Constants {
	private long _consoleIP = 0; // Note: for local direct connetion, this is set to 0
	private long _consolePort = 0; // Note: for local direct connetion, this is set to the instance number
	private RAString _exe = new RAString("");
	private RAString _args = new RAString("");
	private RAString _location = new RAString("");
	private Vector _environment = new Vector();
	private Vector _agents = new Vector();

	public LaunchProcessCommand() {
		super();
		_tag = RA_LAUNCH_PROCESS;
	}

	public void addAgent(String name) {
		_agents.addElement(new RAString(name));
	}

	public void addEnvironmentVariable(String name, String value) {
		_environment.addElement(new RAString(name + "=" + value));
	}

	public String getArgs() {
		if (_args != null) {
			return _args.getData();
		} else {
			return null;
		}
	}

	public long getConsoleIP() {
		return _consoleIP;
	}

	public long getConsolePort() {
		return _consolePort;
	}

	public String getExe() {
		if (_exe != null) {
			return _exe.getData();
		} else {
			return null;
		}
	}

	public String getLocation() {
		if (_location != null) {
			return _location.getData();
		} else {
			return null;
		}
	}

	public Vector getEnvironment() {
		if (_environment != null) {
			return _environment;
		} else {
			return null;
		}
	}

	public Vector getAgents() {
		if (_agents != null) {
			return _agents;
		} else {
			return null;
		}
	}

	public int getSize() {
		int size = super.getSize();

		size += sizeofLong; // consoleIP
		size += sizeofLong; // consolePort
		size += +_exe.getSize();
		size += _args.getSize();
		size += _location.getSize();

		size += sizeofLong; // list size
		for (int i = 0; i < _environment.size(); i++) {
			size += ((RAString) _environment.elementAt(i)).getSize();
		}

		size += sizeofLong; // list size
		for (int i = 0; i < _agents.size(); i++) {
			size += ((RAString) _agents.elementAt(i)).getSize();
		}

		return size;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.readFromBuffer(buffer, current);

		_consoleIP = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		_consolePort = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		current = Message.readRAStringFromBuffer(buffer, current, _exe);
		current = Message.readRAStringFromBuffer(buffer, current, _args);
		current = Message.readRAStringFromBuffer(buffer, current, _location);

		long listLength = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;
		for (int i = 0; i < listLength; i++) {
			RAString envVar = new RAString();
			current = Message.readRAStringFromBuffer(buffer, current, envVar);
			_environment.addElement(envVar);
		}

		listLength = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;
		for (int i = 0; i < listLength; i++) {
			RAString envVar = new RAString();
			current = Message.readRAStringFromBuffer(buffer, current, envVar);
			_agents.addElement(envVar);
		}

		return current;

	}

	public void setArgs(String args) {
		_args = new RAString(args);
	}

	public void setConsole(Console console) throws ConsoleNotStartedException {
		_consoleIP = console.getIP();
		_consolePort = console.getPort();
	}

	public void setConsole(long id) {
		_consoleIP = 0;
		_consolePort = id;
	}

	public void setExe(String exe) {
		_exe = new RAString(exe);
	}

	public void setLocation(String location) {
		_location = new RAString(location);
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.writeToBuffer(buffer, current);
		current = Message.writeRALongToBuffer(buffer, current, _consoleIP);
		current = Message.writeRALongToBuffer(buffer, current, _consolePort);
		current = Message.writeRAStringToBuffer(buffer, current, _exe);
		current = Message.writeRAStringToBuffer(buffer, current, _args);
		current = Message.writeRAStringToBuffer(buffer, current, _location);

		current = Message.writeRALongToBuffer(buffer, current, (long) _environment.size());
		for (int i = 0; i < _environment.size(); i++) {
			current = Message.writeRAStringToBuffer(buffer, current, ((RAString) _environment.elementAt(i)));
		}
		current = Message.writeRALongToBuffer(buffer, current, (long) _agents.size());
		for (int i = 0; i < _agents.size(); i++) {
			current = Message.writeRAStringToBuffer(buffer, current, ((RAString) _agents.elementAt(i)));
		}

		return current;
	}
}
