/**********************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Options.java,v 1.2 2008/03/20 18:49:51 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

public interface Options {

	/* Option Strings */
	public final static String OPTION_MONITOR_MODE = "MONITOR_MODE";//$NON-NLS-1$
	public final static String OPTION_CLASS_LOAD_DETAILS = "CLASS_LOAD_DETAILS";//$NON-NLS-1$
	public final static String OPTION_COLLATION_VALUES = "COLLATION_VALUES";//$NON-NLS-1$
	public final static String OPTION_CONTEXT_FLOW = "CONTEXT_FLOW";//$NON-NLS-1$
	public final static String OPTION_EXCEPTION_TRACING = "EXCEPTION_TRACING";//$NON-NLS-1$
	public final static String OPTION_FILTERS = "FILTERS";//$NON-NLS-1$
	public final static String OPTION_GC = "GC";//$NON-NLS-1$
	public final static String OPTION_ID_STYLE = "ID_STYLE";//$NON-NLS-1$
	public final static String OPTION_METHOD_COUNTS = "METHOD_COUNTS";//$NON-NLS-1$
	public final static String OPTION_OBJ_ALLOC_IS_ARRAY = "OBJ_ALLOC_IS_ARRAY";//$NON-NLS-1$
	public final static String OPTION_OPTIONS = "OPTIONS";//$NON-NLS-1$
	public final static String OPTION_TICKET = "TICKET";//$NON-NLS-1$
	public final static String OPTION_TIMESTAMPS = "TIMESTAMPS";//$NON-NLS-1$
	public final static String OPTION_TRACE_IDREFS = "TRACE_IDREFS";//$NON-NLS-1$
	public final static String OPTION_UNREFERENCED_SYMBOLS = "UNREFERENCED_SYMBOLS";//$NON-NLS-1$
	public final static String OPTION_STACK_INFORMATION = "STACK_INFORMATION";//$NON-NLS-1$
	public final static String OPTION_OBJ_REF_MODE = "OBJ_REF_MODE";//$NON-NLS-1$
	/* V5 additions */
	public final static String OPTION_TRACE_MODE = "TRACE_MODE";//$NON-NLS-1$
	public final static String OPTION_TRACE_START_MODE = "TRACE_START_MODE";//$NON-NLS-1$
	public final static String OPTION_BURST_MODE = "BURST_MODE";//$NON-NLS-1$
	public final static String OPTION_BOUNDARY_DEPTH = "BOUNDARY_DEPTH";//$NON-NLS-1$
	public static final String OPTION_BURST_INVOCATIONS = "BURST_INVOCATIONS";//$NON-NLS-1$
	public static final String OPTION_BURST_SECONDS = "BURST_SECONDS";//$NON-NLS-1$
	public static final String OPTION_ALLOCATION_INFORMATION = "ALLOCATION_INFORMATION";//$NON-NLS-1$

	public static final String OPTION_COMPRESS = "COMPRESS";//$NON-NLS-1$

	public final static String OPTION_CPU_TIME = "CPU_TIME";//$NON-NLS-1$
	/* Option Values */
	public static final String OPTION_VALUE_FULL = "full";//$NON-NLS-1$
	public static final String OPTION_VALUE_ALL = "all";//$NON-NLS-1$
	public static final String OPTION_VALUE_TRUE = "true";//$NON-NLS-1$
	public static final String OPTION_VALUE_FALSE = "false";//$NON-NLS-1$
	public static final String OPTION_VALUE_STATIC = "static";//$NON-NLS-1$
	public static final String OPTION_VALUE_RELOCATABLE = "relocatable";//$NON-NLS-1$
	public static final String OPTION_VALUE_STATICANDRELOCATABLE = "staticAndRelocatable";//$NON-NLS-1$
	public static final String OPTION_VALUE_DEFAULT = "default";//$NON-NLS-1$
	public static final String OPTION_VALUE_NONE = "none";//$NON-NLS-1$
	public static final String OPTION_VALUE_DELETES = "deletes";//$NON-NLS-1$
	public static final String OPTION_VALUE_DELETESANDMOVES = "deletesAndMoves";//$NON-NLS-1$
	public static final String OPTION_VALUE_NORMAL = "normal";//$NON-NLS-1$
	public static final String OPTION_VALUE_BOUNDARY = "boundary";//$NON-NLS-1$
	public static final String OPTION_VALUE_CONTIGUOUS = "contiguous";//$NON-NLS-1$
	public static final String OPTION_VALUE_BOUNDARYANDCONTIGUOUS = "boundaryAndContiguous";//$NON-NLS-1$
	public static final String OPTION_VALUE_RESPECT_FILTER = "respectFilter";//$NON-NLS-1$
	public static final String OPTION_VALUE_FILTER_OWNER = "filterOwner";//$NON-NLS-1$
	public static final String OPTION_VALUE_IGNORE_FILTER = "ignoreFilter";//$NON-NLS-1$
	/* V5 Additions */
	public final static String OPTION_VALUE_NOOBJECTCORRELATION = "noObjectCorrelation";//$NON-NLS-1$
	public static final String OPTION_VALUE_FILTER = "filter";
	public static final String OPTION_VALUE_TRIGGERSINGLETHREADED = "triggerSingleThreaded";//$NON-NLS-1$
	public static final String OPTION_VALUE_TRIGGERMULTITHREADED = "triggerMultiThreaded";//$NON-NLS-1$
	public static final String OPTION_VALUE_INVOCATIONS = "invocations";//$NON-NLS-1$
	public static final String OPTION_VALUE_SECONDS = "seconds";//$NON-NLS-1$
	public static final String OPTION_VALUE_SECONDSANDINVOCATIONS = "secondsAndInvocations";//$NON-NLS-1$

	public static final String OPTION_VALUE_AGGREGATE = "aggregate";//$NON-NLS-1$

	/*
	 * This option must be in place if the user has selected execution flow without instance level information.
	 */
	public final static String[][] OPTIONS_EXECUTION_FLOW = { { OPTION_TRACE_MODE, OPTION_VALUE_NOOBJECTCORRELATION }, { OPTION_STACK_INFORMATION, OPTION_VALUE_NORMAL }, { OPTION_TICKET, OPTION_VALUE_TRUE } };

	/*
	 * This option must be in place if the user has selected execution flow with instance level information.
	 */
	public final static String[][] OPTIONS_EXECUTION_FLOW_INSTANCES = { { OPTION_TRACE_MODE, OPTION_VALUE_FULL }, { OPTION_ALLOCATION_INFORMATION, OPTION_VALUE_DEFAULT }, { OPTION_STACK_INFORMATION, OPTION_VALUE_NORMAL }, { OPTION_TICKET, OPTION_VALUE_TRUE } };

	/*
	 * This option must be used if the user has selected execution flow and some boundary information, but no instance level information.
	 */
	public final static String[][] OPTIONS_EXECUTION_FLOW_BOUNDARY = { { OPTION_TRACE_MODE, OPTION_VALUE_NOOBJECTCORRELATION }, { OPTION_STACK_INFORMATION, OPTION_VALUE_BOUNDARY }, { OPTION_TICKET, OPTION_VALUE_TRUE } };

	/*
	 * This option must be used if the user has selected execution flow and some boundary information, as well as instance level information.
	 */
	public final static String[][] OPTIONS_EXECUTION_FLOW_BOUNDARY_INSTANCES = { { OPTION_TRACE_MODE, OPTION_VALUE_FULL }, { OPTION_ALLOCATION_INFORMATION, OPTION_VALUE_DEFAULT }, { OPTION_STACK_INFORMATION, OPTION_VALUE_BOUNDARY }, { OPTION_TICKET, OPTION_VALUE_TRUE } };

	/*
	 * This option must be in place if the user has selected that they do not want any execution behaviour at all.
	 */
	public final static String[][] OPTIONS_EXECUTION_FLOW_NONE = { { OPTION_STACK_INFORMATION, OPTION_VALUE_NONE }, { OPTION_TICKET, OPTION_VALUE_TRUE } };

	/* This option must be in place if the user has selected to collect cpu time events */
	public final static String[][] OPTIONS_COLLECT_CPU_TIME = { { OPTION_CPU_TIME, OPTION_VALUE_TRUE }, };

	/*
	 * This option must be in place if the user does not want object correlation information.
	 */
	public final static String[][] OPTIONS_NO_INSTANCE_INFORMATION = { { OPTION_TRACE_MODE, OPTION_VALUE_NOOBJECTCORRELATION }, { OPTION_ALLOCATION_INFORMATION, OPTION_VALUE_NONE } };

	public final static String[][] OPTIONS_ANALYZE_HEAP = { { OPTION_TRACE_MODE, OPTION_VALUE_FULL }, { OPTION_ALLOCATION_INFORMATION, OPTION_VALUE_DEFAULT }, { OPTION_TICKET, OPTION_VALUE_TRUE } };

	public final static String[][] OPTIONS_ANALYZE_HEAP_NONE = { { OPTION_TRACE_MODE, OPTION_VALUE_NOOBJECTCORRELATION }, { OPTION_ALLOCATION_INFORMATION, OPTION_VALUE_NONE } };

	/*
	 * This option must be in place if the user has selected Method Coverage but not EXECUTION_FLOW
	 */
	public final static String[][] OPTIONS_COVERAGE_NO_FLOW = { { OPTION_TRACE_MODE, OPTION_VALUE_NOOBJECTCORRELATION }, { OPTION_STACK_INFORMATION, OPTION_VALUE_NORMAL }, { OPTION_METHOD_COUNTS, OPTION_VALUE_TRUE }, { OPTION_UNREFERENCED_SYMBOLS, OPTION_VALUE_TRUE } };

	/*
	 * This option must be in place if the user has selected method coverage.
	 */
	public final static String[][] OPTIONS_COVERAGE = { { OPTION_TRACE_MODE, OPTION_VALUE_NOOBJECTCORRELATION }, { OPTION_METHOD_COUNTS, OPTION_VALUE_TRUE }, { OPTION_UNREFERENCED_SYMBOLS, OPTION_VALUE_TRUE } };

	/* This option must be in place if the user has selected to observe threading events */

	public final static String[][] OPTIONS_THREAD_EVENTS = { { OPTION_MONITOR_MODE, OPTION_VALUE_ALL } };

	/*
	 * These are the default options, when nothing is selected. Nothing should be collected. These defaults are overridden once the options are set with values of higher precedence.
	 */
	public final static String[][] OPTIONS_DEFAULT = { { OPTION_TRACE_MODE, OPTION_VALUE_NONE }, { OPTION_ALLOCATION_INFORMATION, OPTION_VALUE_NONE }, { OPTION_STACK_INFORMATION, OPTION_VALUE_NONE }, { OPTION_TICKET, OPTION_VALUE_TRUE } };
}
