/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProcessLaunchedCommand.java,v 1.1 2007/04/09 14:04:23 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

import java.util.Vector;

public class ProcessLaunchedCommand extends DetailedProcessCommand {

	RAString _exe = new RAString("");
	RAString _args = new RAString("");
	Vector _environment = new Vector();

	/**
	 * ProcessLaunchedCommand constructor comment.
	 */
	public ProcessLaunchedCommand() {
		super();
		_tag = RA_PROCESS_LAUNCHED;
	}

	/**
	 * Insert the method's description here. Creation date: (10/31/00 7:42:56 PM)
	 * 
	 * @param name
	 *            java.lang.String
	 * @param value
	 *            java.lang.String
	 */
	public void addEnvironmentVariable(String name, String value) {
		_environment.addElement(new RAString(name + "=" + value));
	}

	/**
	 * Insert the method's description here. Creation date: (6/2/00 12:59:18 PM)
	 * 
	 * @return java.lang.String
	 */
	public String getArgs() {
		if (_args != null)
			return _args.getData();
		return null;
	}

	/**
	 * Insert the method's description here. Creation date: (11/9/00 9:02:18 AM)
	 * 
	 * @return java.lang.String[]
	 */
	public String[] getEnvironment() {
		String[] result = new String[_environment.size()];
		for (int i = 0; i < _environment.size(); i++) {
			result[i] = ((RAString) (_environment.elementAt(i))).getData();
		}

		return result;
	}

	/**
	 * Insert the method's description here. Creation date: (9/11/00 8:58:33 PM)
	 * 
	 * @return java.lang.String
	 */
	public String getExe() {
		if (_exe != null)
			return _exe.getData();

		return null;
	}

	/**
	 * Insert the method's description here. Creation date: (6/8/00 1:00:36 PM)
	 * 
	 * @return int
	 */
	public int getSize() {
		int size = super.getSize();
		size += _exe.getSize();
		size += _args.getSize();

		size += sizeofLong;

		for (int i = 0; i < _environment.size(); i++) {
			size += ((RAString) _environment.elementAt(i)).getSize();
		}

		return size;
	}

	/**
	 * Insert the method's description here. Creation date: (9/11/00 10:20:50 PM)
	 * 
	 * @return int
	 * @param buffer
	 *            byte[]
	 * @param offset
	 *            int
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current = super.readFromBuffer(buffer, offset);
		current = Message.readRAStringFromBuffer(buffer, current, _exe);
		current = Message.readRAStringFromBuffer(buffer, current, _args);

		long listLength = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;
		for (int i = 0; i < listLength; i++) {
			RAString envVar = new RAString("");
			current = Message.readRAStringFromBuffer(buffer, current, envVar);
			_environment.addElement(envVar);
		}

		return current;

	}

	/**
	 * Insert the method's description here. Creation date: (6/2/00 1:00:01 PM)
	 * 
	 * @param args
	 *            java.lang.String
	 */
	public void setArgs(String args) {
		_args = new RAString(args);
	}

	/**
	 * Insert the method's description here. Creation date: (9/11/00 8:58:07 PM)
	 * 
	 * @param exe
	 *            java.lang.String
	 */
	public void setExe(String exe) {
		_exe = new RAString(exe);
	}

	/**
	 * Insert the method's description here. Creation date: (7/21/00 2:36:20 PM)
	 * 
	 * @return int
	 * @param buffer
	 *            byte[]
	 * @param offset
	 *            int
	 */

	public void setEnvironment(String[] env) {
		if (env != null) {
			int count = env.length;
			for (int i = 0; i < count; i++) {
				RAString entry = new RAString(env[i]);
				_environment.add(entry);
			}
		}
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = super.writeToBuffer(buffer, offset);
		current = Message.writeRAStringToBuffer(buffer, current, _exe);
		current = Message.writeRAStringToBuffer(buffer, current, _args);

		current = Message.writeRALongToBuffer(buffer, current, _environment.size());

		for (int i = 0; i < _environment.size(); i++) {
			current = Message.writeRAStringToBuffer(buffer, current, ((RAString) _environment.elementAt(i)));
		}
		return current;
	}
}
