/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResourceLocation.java,v 1.1 2007/04/09 14:04:24 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local.common;

public class ResourceLocation extends CommandElement implements Constants {
	private long _port;
	private RAString _jobKey = new RAString("");

	public ResourceLocation() {
		super();
		_tag = RA_RESOURCE_LOCATION;
	}

	public int getPort() {
		return (int) _port;
	}

	public void setPort(int port) {
		_port = port;
	}

	public String getJobKey() {
		return _jobKey.getData();
	}

	public void setJobKey(String key) {
		_jobKey = new RAString(key);
	}

	public int getSize() {
		int size = super.getSize();

		size += sizeofLong; // port
		size += _jobKey.getSize();

		return size;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.readFromBuffer(buffer, current);

		_port = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		current = Message.readRAStringFromBuffer(buffer, current, _jobKey);

		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.writeToBuffer(buffer, current);
		current = Message.writeRALongToBuffer(buffer, current, _port);
		current = Message.writeRAStringToBuffer(buffer, current, _jobKey);

		return current;
	}
}
