/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ServerSecurityInfoCommand.java,v 1.1 2007/04/09 14:04:24 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

public class ServerSecurityInfoCommand extends CommandElement implements Constants {
	private long _flag;
	private long _port;

	public ServerSecurityInfoCommand() {
		super();
		_tag = RA_SERVER_SECURITY_REQUIREMENTS;
	}

	public int getSize() {
		int size = super.getSize();

		size += sizeofLong; // flag
		size += sizeofLong; // port

		return size;
	}

	public long getSecurePort() {
		return _port;
	}

	public boolean isPasswordProtected() {
		return _flag < 3;
	}

	public boolean isClientAuthenticationRequired() {
		return _flag > 1;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		/*
		 * Cannot call super.readFromBuffer() since this command does not have a context
		 */
		// current = super.readFromBuffer(buffer, current);
		_flag = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		_port = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		/*
		 * Cannot call super.writeToBuffer() since this command does not have a context
		 */
		// current = super.writeToBuffer(buffer, current);
		current = Message.writeRALongToBuffer(buffer, current, _tag);
		current = Message.writeRALongToBuffer(buffer, current, _flag);
		current = Message.writeRALongToBuffer(buffer, current, _port);

		return current;
	}
}
