/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StartMonitoringLocalAgentCommand.java,v 1.1 2007/04/09 14:04:25 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

public class StartMonitoringLocalAgentCommand extends SimpleAgentInfoCommand {
	private RAString _file = new RAString();

	public StartMonitoringLocalAgentCommand() {
		super();
		_tag = RA_START_MONITORING_AGENT_LOCAL;
	}

	public String getFile() {
		return _file.getData();
	}

	public void setFile(String file) {
		_file = new RAString(file);
	}

	public int getSize() {
		return super.getSize() + _file.getSize();
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = super.readFromBuffer(buffer, offset);
		current = Message.readRAStringFromBuffer(buffer, current, _file);

		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = super.writeToBuffer(buffer, offset);
		current = Message.writeRAStringToBuffer(buffer, current, _file);

		return current;
	}

}
