/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StartMonitoringRemoteAgentCommand.java,v 1.1 2007/04/09 14:04:24 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.common;

import java.net.InetAddress;

public class StartMonitoringRemoteAgentCommand extends SimpleAgentInfoCommand {

	protected long _port = 0;
	protected long _ip = 0;

	/**
	 * SetMonitorCommandEntry constructor comment.
	 */
	public StartMonitoringRemoteAgentCommand() {
		super();
		_tag = RA_START_MONITORING_AGENT_REMOTE;
	}

	/**
	 * Insert the method's description here. Creation date: (11/3/00 11:06:34 AM)
	 */
	public long getIP() {
		return _ip;
	}

	/**
	 * Insert the method's description here. Creation date: (6/8/00 12:23:51 PM)
	 * 
	 * @return short
	 */
	public long getPort() {
		return _port;
	}

	/**
	 * Insert the method's description here. Creation date: (6/8/00 12:58:48 PM)
	 * 
	 * @return int
	 */
	public int getSize() {
		return super.getSize() + 2 * sizeofLong;
	}

	/**
	 * Insert the method's description here. Creation date: (9/11/00 9:25:14 PM)
	 * 
	 * @return int
	 * @param buffer
	 *            byte[]
	 * @param length
	 *            int[]
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current = super.readFromBuffer(buffer, offset);

		_ip = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		_port = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		return current;
	}

	/**
	 * Insert the method's description here. Creation date: (11/3/00 11:06:19 AM)
	 * 
	 * @param param
	 *            java.net.InetAddress
	 */
	public void setInetAddress(InetAddress param) {
		byte[] addr_bytes = param.getAddress();
		_ip = 0;
		_ip += (addr_bytes[3] << 24) & (0xFF000000);
		_ip += (addr_bytes[2] << 16) & (0x00FF0000);
		_ip += (addr_bytes[1] << 8) & (0x0000FF00);
		_ip += (addr_bytes[0]) & (0x000000FF);
	}

	/**
	 * Insert the method's description here. Creation date: (6/8/00 12:23:41 PM)
	 * 
	 * @param port
	 *            short
	 */
	public void setPort(short port) {
		_port = port;
	}

	/**
	 * Insert the method's description here. Creation date: (7/21/00 3:41:09 PM)
	 * 
	 * @return int
	 * @param buffer
	 *            byte[]
	 * @param offset
	 *            int
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current = super.writeToBuffer(buffer, offset);
		current = Message.writeRALongToBuffer(buffer, current, _ip);
		current = Message.writeRALongToBuffer(buffer, current, _port);

		return current;
	}
}
