/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProcessFactory.java,v 1.1 2007/04/09 14:04:25 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.control;

public class ProcessFactory {

	public static Process createProcess(Node node) {
		Process process = new ProcessImpl(node);
		if (node instanceof NodeImpl) {
			process.addProcessListener(((NodeImpl) node).getProcessListener());
		}
		return process;
	}

	public static Process createProcess(Node node, long pid) {
		Process process = new ProcessImpl(node, pid);
		if (node instanceof NodeImpl) {
			process.addProcessListener(((NodeImpl) node).getProcessListener());
		}
		return process;
	}

	public static Process createProcess(Node node, String executable) {
		Process process = new ProcessImpl(node, executable);
		if (node instanceof NodeImpl) {
			process.addProcessListener(((NodeImpl) node).getProcessListener());
		}
		return process;
	}

	public static Process createProcess(Node node, String executable, long pid) {
		Process process = new ProcessImpl(node, executable, pid);
		if (node instanceof NodeImpl) {
			process.addProcessListener(((NodeImpl) node).getProcessListener());
		}
		return process;
	}

	public static Process createProcess(Node node, String executable, String parameters) {
		Process process = new ProcessImpl(node, executable, parameters);
		if (node instanceof NodeImpl) {
			process.addProcessListener(((NodeImpl) node).getProcessListener());
		}
		return process;
	}
}
