/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: FileManagerImpl.java,v 1.6 2005/06/13 15:16:02 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.execution.local.file;

import java.io.IOException;

import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.local.control.Connection;

/**
 * The class that previously had this name has been deprecated to the file
 * manager legacy class and this class becomes a bridge class bridging the old
 * expected class and implicit and explicit interfaces to the new implementation
 * that uses a factory to determine if the old or new file server is in use on
 * the agent controller installation
 * 
 * @author Scott E. Schneider
 * 
 * @see org.eclipse.hyades.execution.local.file.FileManagerFactory
 * 
 * @deprecated Create a file manager instance using the file manager factory
 *             instead of directly instantiating the file manager implementation
 *             class
 */
public class FileManagerImpl extends ExecutionComponentImpl implements IFileManager {

    private final IFileManager manager;

    /**
     * Constructs a new file manager implementation to be used for transferring
     * and managing files on the agent controller machine; the recommended
     * method of obtaining the file manager implementation is to use the public
     * file manager factory
     * 
     * @param connection
     *            the connection to the agent controller
     * @throws ServerNotAvailableException
     */
    public FileManagerImpl(Connection connection) throws ServerNotAvailableException {
        this.manager = FileManagerFactory.getInstance().create(connection);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.execution.core.file.IFileManager#getFile(java.lang.String,
     *      java.lang.String)
     */
    public void getFile(String localName, String remoteName) throws IOException {
        this.manager.getFile(localName, remoteName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.execution.core.file.IFileManager#putFile(java.lang.String,
     *      java.lang.String)
     */
    public void putFile(String localName, String remoteName) throws IOException {
        this.manager.putFile(localName, remoteName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.execution.core.file.IFileManager#deleteFile(java.lang.String)
     */
    public void deleteFile(String remoteName) throws IOException {
        this.manager.deleteFile(remoteName);
    }
}