/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IFileManagerFactory.java,v 1.6 2005/10/05 22:02:00 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.execution.local.file;

import java.net.InetSocketAddress;

import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.local.control.Connection;

/**
 * Interface to the file manager factory, a file manager is created using this
 * factory and can be either instantiated within the agent controller in process
 * or instantiated outside of any agent controller interaction at all (the agent
 * controller does not need to be running for the connection less case).
 * 
 * @author Scott E. Schneider
 */
public interface IFileManagerFactory {
	/**
	 * Creates a new file manager for the client to use in normal mode without
	 * performance timing integration
	 * 
	 * @param connection
	 *            the connection to the agent controller
	 * @return the configured file manager
	 * @throws ServerNotAvailableException
	 */
	public IFileManagerExtended create(Connection connection) throws ServerNotAvailableException;

	/**
	 * Creates a new file manager for the client to use in normal mode without
	 * performance timing integration
	 * 
	 * @param fileServerAddress
	 *            address and port information for server
	 * @return the configured file manager
	 * @throws ServerNotAvailableException
	 */
	public IFileManagerExtended create(InetSocketAddress fileServerAddress) throws ServerNotAvailableException;

	/**
	 * Create a new timed file manager for the client to use in timed mode
	 * 
	 * @param connection
	 *            the connection to the agent controller to use
	 * @param iterations
	 *            the number of times each method invocation will be called
	 * @return the configured file manager
	 * @throws ServerNotAvailableException
	 */
	public IFileManagerExtended createTimed(Connection connection, int iterations) throws ServerNotAvailableException;

	/**
	 * Create a new timed file manager for the client to use in timed mode
	 * 
	 * @param fileServerAddress
	 *            address and port information for server
	 * @param iterations
	 *            the number of times each method invocation will be called
	 * @return the configured file manager
	 * @throws ServerNotAvailableException
	 */
	public IFileManagerExtended createTimed(InetSocketAddress fileServerAddress, int iterations)
			throws ServerNotAvailableException;
}
