/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local.internal.resources;

import org.eclipse.osgi.util.NLS;

/**
 * Local resource bundle.
 * <p>
 * 
 * 
 * @author      Tony Wang
 * @version     March 14, 2008
 * @since       March 11, 2008
 */
public final class LocalResourceBundle extends NLS {

	private static final String BUNDLE_NAME = "org.eclipse.hyades.execution.local.internal.resources.messages";//$NON-NLS-1$

	private LocalResourceBundle() {
		// Do not instantiate
	}

	public static String DataChannelImpl_CANNOT_FIND_LIBRARY_;
	public static String DataChannelImpl_ALREADY_EXIST_;
	public static String DataChannelImpl_DOES_NOT_EXIST_;
	public static String DataChannelImpl_INVALID_;
	public static String DataChannelImpl_CANNOT_ALLOCATE_MEMORY_;
	public static String DataChannelImpl_IMPLEMENTATION_FAILURE_;
	public static String DataChannelImpl_FLUSHER_THREAD_INTERRUPTED_;
	public static String DataChannelImpl_WRITER_THREAD_INTERRUPTED_;
	public static String DataChannelImpl_NO_SET_NAME_;
	public static String DatachannelImpl_WRITING_ERROR_;

	public static String EclipseExecutionComponentFactoryImpl_CANNOT_CONFIGURE_TYPE_;
	public static String EclipseExecutionComponentFactoryImpl_INCORRECT_TYPE_;
	public static String EclipseExecutionComponentFactoryImpl_FACTORY_CANNOT_CONFIGURE_TYPE_;
	public static String EclipseExecutionComponentFactoryImpl_NOT_INSTANCE_VALUE_;
	
	public static String ExecutionComponentFactoryImpl_SESSION_CONTEXT_SHOULD_NOT_SET_;
	public static String ExecutionComponentFactoryImpl_CLASS_NOT_SPECIFIED_;
	
	public static String ExecutorStub_RETURN_INCORRECT_TYPE_;
	
	public static String JavaProcessExecutorStub_UNABLE_FIND_CONTROL_AGENT_;
	
	public static String JavaTaskExecutorStub_RETURN_INCORRECT_TYPE_;
	public static String JavaTaskExecutorStub_HANDLE_COMMAND_CALLED_;
	public static String JavaTaskExecutorStub_INACTIVE_AGENT_;
	
	public static String JavaTaskRemoteHyadesComponentStub_INCORRECT_DATATYPE_RETURNED_;
	public static String JavaTaskRemoteHyadesComponentStub_NOT_IMPLEMENTED_OPERATION_;
	public static String JavaTaskRemoteHyadesComponentStub_DATA_PROCESSOR_TYPE_;
	
	public static String RemoteObjectStub_CLASS_NOT_A_CHILD_;
	
	public static String FileManagerFactory_FILE_SYSTEM_SERVICE_;
	public static String FileManagerFactory_EXCEPTION_ENCOUNTERED_;
	public static String FileManagerFactory_CREATE_FILE_MANAGER_;
	
	public static String SecureClient_SESSION_NULL_CONNETCION_FAILED_;
	public static String SecureClient_NO_SOCKET_SESSION_CREATED_;
	
	public static String FileServerExtended_EXTENDED_FILE_SERVER_INITIALIZED_;
	public static String FileServerExtended_EXTENDED_FILE_SERVER_LISTENING_;
	public static String FileServerExtended_BIND_FILE_SERVER_SOCKET_EXCEPTION_;
	public static String FileServerExtended_CANNOT_INITIALIZE_;

	public static String FileClientHandlerExtendedImpl_CLASS_PROVIDED_FROM_CLIENT_;
	public static String FileClientHandlerExtendedImpl_COMMAND_IDENTITY_LENGTH_;
	public static String FileClientHandlerExtendedImpl_COMMAND_BEING_DELEGATED_;
	
	public static String FileConnectionHandlerExtended_ACCEPTED_AND_ESTABLISHED_CONNECTION_;
	
	public static String ControlMessage_NOT_ENOUGH_BYTES_;
	
	public static String MultiplexedDataServer_CORRUPTED_DATA_;
	public static String MultiplexedDataServer_NO_ENOUGH_BYTES_;
	public static String MultiplexedDataServer_NO_VALID_HEADER_;
	public static String MultiplexedDataServer_NO_ENOUGH_HEADER_BYTES_;
	
	public static String TCPDataServer_DATA_SERVER_IS_PROCESSING_;
	public static String TCPDataServer_DATA_SERVER_SHUT_DOWN_;
	public static String TCPDataServer_DATA_SERVER_SHUT_DOWN_AFTER_;
	public static String TCPDataServer_DATA_SERVER_STEP_OUTER_;
    public static String TCPDataServer_DATA_SERVER_EXIT_OUTER_LOOP_;
    public static String TCPDataServer_DATA_SERVER_DONE_ENTER_;
    public static String TCPDataServer_DATA_SERVER_DONE_CONNECTION_CLOSED_;
    public static String TCPDataServer_DATA_SERVER_RECOVER_;
    public static String TCPDataServer_DATA_SERVER_INVALID_MAGIC_NUMBER_;
    public static String TCPDataServer_DATA_SERVER_NEW_SHUT_DOWN_;    
	public static String TCPDataServer_DATA_PROCESSOR_RUN_;
	public static String TCPDataServer_BUFFERFLUSHER_DATA_REPLACEMENT_;
	public static String TCPDataServer_BUFFERFLUSHER_DATA_REPLACEMENT_LENGTH1_;
	public static String TCPDataServer_BUFFERFLUSHER_DATA_REPLACEMENT_LENGTH2_;
	public static String TCPDataServer_BUFFERFLUSHER_CORRUPT_DATA_;
    public static String TCPDataServer_DATA_PROCESSOR_END_;
    public static String TCPDataServer_DATA_PROCESSOR_END_EXCEPTION_;
    public static String TCPDataServer_DATA_PROCESSOR_TIMEOUT_;
    public static String TCPDataServer_DATA_PROCESSOR_MONITORING_STOPPED_;
    public static String TCPDataServer_DATA_PROCESSOR_CLOSE_SOCKET_;
    public static String TCPDataServer_CURRENT_HEADER_OFFSET_;
    public static String TCPDataServer_CURRENT_BUFFER_LENGTH_;
    public static String TCPDataServer_GET_MESSAGE_LENGTH_;
    public static String TCPDataServer_GET_MESSAGE_TYPE_;
    
    public static String SecureConnectionImpl_NOT_SUPPORTED_PROTOCOLS_EXCEPTION_;
    
    public static String Test_FILE_TRANSFER_COMPLETE_;
    public static String Test_ERROR_CREATING_SESSION_;
	
	
	
	
	static {
		NLS.initializeMessages(BUNDLE_NAME, LocalResourceBundle.class);
	}
}
