/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local.pub.internal.resources;

import org.eclipse.osgi.util.NLS;

/**
 * Local Public resource bundle.
 * <p>
 * 
 * 
 * @author      Tony Wang
 * @version     March 12, 2008
 * @since       March 12, 2008
 */
public final class LocalPublicResourceBundle extends NLS {

	private static final String BUNDLE_NAME = "org.eclipse.hyades.execution.local.pub.internal.resources.messages";//$NON-NLS-1$

	private LocalPublicResourceBundle() {
		// Do not instantiate
	}

	public static String ControlMessage_NOT_ENOUGH_BYTES_;
	
	public static String MultiplexedDataServer_CORRUPTED_DATA_ERROR_;
	public static String MultiplexedDataServer_ENOUGH_BYTES_ERROR_;
	public static String MultiplexedDataServer_VALID_HEADER_ERROR_;
	public static String MultiplexedDataServer_ENOUGH_HEADER_BYTES_ERROR_;
	
	public static String TCPDataServer_DATA_SERVER_IS_PROCESSING_;
	public static String TCPDataServer_DATA_SERVER_SHUT_DOWN_;
	public static String TCPDataServer_DATA_SERVER_SHUT_DOWN_AFTER_;
	public static String TCPDataServer_DATA_SERVER_STEP_OUTER_;
    public static String TCPDataServer_DATA_SERVER_EXIT_OUTER_LOOP_;
    public static String TCPDataServer_DATA_SERVER_DONE_ENTER_;
    public static String TCPDataServer_DATA_SERVER_DONE_CONNECTION_CLOSED_;
    public static String TCPDataServer_DATA_SERVER_RECOVER_;
    public static String TCPDataServer_DATA_SERVER_INVALID_MAGIC_NUMBER_;
    public static String TCPDataServer_DATA_SERVER_NEW_SHUT_DOWN_;    
	public static String TCPDataServer_DATA_PROCESSOR_RUN_;
	public static String TCPDataServer_BUFFERFLUSHER_DATA_REPLACEMENT_;
	public static String TCPDataServer_BUFFERFLUSHER_DATA_REPLACEMENT_LENGTH1_;
	public static String TCPDataServer_BUFFERFLUSHER_DATA_REPLACEMENT_LENGTH2_;
	public static String TCPDataServer_BUFFERFLUSHER_CORRUPT_DATA_;
    public static String TCPDataServer_DATA_PROCESSOR_END_;
    public static String TCPDataServer_DATA_PROCESSOR_END_EXCEPTION_;
    public static String TCPDataServer_DATA_PROCESSOR_TIMEOUT_;
    public static String TCPDataServer_DATA_PROCESSOR_MONITORING_STOPPED_;
    public static String TCPDataServer_DATA_PROCESSOR_CLOSE_SOCKET_;
    public static String TCPDataServer_CURRENT_HEADER_OFFSET_;
    public static String TCPDataServer_CURRENT_BUFFER_LENGTH_;
    public static String TCPDataServer_GET_MESSAGE_LENGTH_;
    public static String TCPDataServer_GET_MESSAGE_TYPE_;
    
    public static String SecureConnectionImpl_NOT_SUPPORTED_PROTOCOLS_EXCEPTION_;

	
	static {
		NLS.initializeMessages(BUNDLE_NAME, LocalPublicResourceBundle.class);
	}
}
