/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: AbstractTestService.java,v 1.3 2006/05/12 18:57:51 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.execution.local.testservices;

import java.lang.reflect.Method;
import com.ibm.icu.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.hyades.internal.execution.local.control.Agent;

/**
 * @author jtoomey
 *
 */
public abstract class AbstractTestService implements ITestService{
	
	// DO NOT TRANSLATE THESE STRINGS.
	// These strings are used in the communication between workebnch service
	// provider and agent service consumer.  They are not user visible.
	public static final String EXCEPTION = "Exception:"; //$NON-NLS-1$
	public static final String METHOD_ARGS = "method=(.*),args:(.*)"; //$NON-NLS-1$
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.testservices.ITestService#run(java.lang.String)
	 */
	public String run(String args, Agent agent) {
		String retVal = null;
		StringBuffer errBuf = new StringBuffer();
		Pattern pattern = Pattern.compile(METHOD_ARGS); 
		Matcher matcher = pattern.matcher(args);
		if (matcher.find()) {
			String method = matcher.group(1);
			String methodArgs = matcher.group(2);
			Class[] parameterTypes = {Agent.class, String.class, StringBuffer.class};
			Method serviceMethod;
			try {
				serviceMethod = this.getClass().getMethod(method, parameterTypes);
				if (serviceMethod != null) {
					Object obj = this;
					Object[] objArgs = {agent, methodArgs, errBuf};
					Object returnObj = serviceMethod.invoke(obj, objArgs);
					try {
						retVal = (String) returnObj;
					} catch (ClassCastException e) {
						Object[] messageElements = {method};
						errBuf.append(MessageFormat.format(Messages.getString("AbstractTestService.SERVICE_NOT_STRING"), messageElements)); //$NON-NLS-1$
					}					
				}
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (Exception e) {
				Object[] messageElements = {method};
				errBuf.append(MessageFormat.format(Messages.getString("AbstractTestService.UNKNOWN_METHOD"), messageElements)); //$NON-NLS-1$
			}
		}
		else {
			Object[] messageElements = {args};
			errBuf.append(MessageFormat.format(Messages.getString("AbstractTestService.BAD_PARSE_SERVICE"), messageElements)); //$NON-NLS-1$
		}
		
		if (retVal == null) {
			retVal = EXCEPTION + errBuf.toString();
		}
		return retVal;
	}
	
	
}
