/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ITestService.java,v 1.1 2006/03/10 19:02:46 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.execution.local.testservices;

import org.eclipse.hyades.internal.execution.local.control.Agent;

/**
 * @author jtoomey
 *
 */
public interface ITestService {
	
	public static final String TEST_SERVICE_SEPARATOR = "##"; //$NON-NLS-1$
	public static final String TEST_SERVICE_PREFIX = "TestService"; //$NON-NLS-1$
	
	public static final String TEST_SERVICE_INVOCATION_PREFIX = "TestServiceCall:";//$NON-NLS-1$
	public static final String TEST_SERVICE_INVOCATION_PATTERN = TEST_SERVICE_INVOCATION_PREFIX + "([^#]+)" + TEST_SERVICE_SEPARATOR + "(\\d+)" + TEST_SERVICE_SEPARATOR + "(.*)"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

	public static final String TEST_SERVICE_RETURN_PREFIX = "TestServiceReturn:"; //$NON-NLS-1$
	public static final String TEST_SERVICE_RETURN_PATTERN = TEST_SERVICE_RETURN_PREFIX + "(\\d+)" + TEST_SERVICE_SEPARATOR + "(.*)"; //$NON-NLS-1$ //$NON-NLS-2$
	
	public static final String TEST_SERVICE_MALFORMED_PREFIX = "TestServiceMalformed:"; //$NON-NLS-1$
	public static final String TEST_SERVICE_MALFORMED_PATTERN = TEST_SERVICE_MALFORMED_PREFIX + "(.*)"; //$NON-NLS-1$

	public static final String TEST_SERVICE_UNKNOWN_PREFIX = "TestServiceUnknown:"; //$NON-NLS-1$
	public static final String TEST_SERVICE_UNKNOWN_PATTERN = TEST_SERVICE_UNKNOWN_PREFIX + "(\\d)"; //$NON-NLS-1$

	public abstract String run (String args, Agent agent);
	
}
