/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: TestServiceAgentListener.java,v 1.3 2006/03/10 19:02:46 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.execution.local.testservices;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;

/**
 * @author jtoomey
 *
 */
public class TestServiceAgentListener implements AgentListener {

	/**
	 * 
	 */
	public TestServiceAgentListener() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.local.control.AgentListener#agentActive(org.eclipse.hyades.internal.execution.local.control.Agent)
	 */
	public void agentActive(Agent agent) {}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.local.control.AgentListener#agentInactive(org.eclipse.hyades.internal.execution.local.control.Agent)
	 */
	public void agentInactive(Agent agent) {}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.local.control.AgentListener#error(org.eclipse.hyades.internal.execution.local.control.Agent, java.lang.String, java.lang.String)
	 */
	public void error(Agent agent, String errorId, String errorMessage) {}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.local.control.AgentListener#handleCommand(org.eclipse.hyades.internal.execution.local.control.Agent, org.eclipse.hyades.internal.execution.local.common.CommandElement)
	 */
	public void handleCommand(Agent agent, CommandElement command) {
		if(command instanceof CustomCommand) {
			CustomCommand customCommand = (CustomCommand) command;
			String commandData=customCommand.getData();
			StringBuffer returnCommand = new StringBuffer();
			
			if ( commandData.startsWith(ITestService.TEST_SERVICE_INVOCATION_PREFIX))
			{
				// Parse out the service name and parameter list
				Pattern pattern = Pattern.compile(ITestService.TEST_SERVICE_INVOCATION_PATTERN);
				Matcher matcher = pattern.matcher(commandData);
				if (matcher.find()) {
					String service = matcher.group(1);
					String id = matcher.group(2);
					String args = matcher.group(3);

					ITestService serviceImpl = getTestService(service);

					if (serviceImpl != null) {
						// TODO JPT: Should we do this in a separate thread?
						String result = serviceImpl.run(args, agent);
						// Return a result command to the caller
						returnCommand.append(ITestService.TEST_SERVICE_RETURN_PREFIX);
						returnCommand.append(id);
						returnCommand.append(ITestService.TEST_SERVICE_SEPARATOR);
						returnCommand.append(result);
					}
					else {
						// We couldn't find the named service among the registered
						// testservice extension points.  Return a unknown command to the caller
						returnCommand.append(ITestService.TEST_SERVICE_UNKNOWN_PREFIX);
						returnCommand.append(id);
					}
				}
				else {
					// The caller invoked a service, but the invocation was not
					// well formed.  Return a malformed command to the caller.
					returnCommand.append(ITestService.TEST_SERVICE_MALFORMED_PREFIX);
					returnCommand.append(commandData);					
				}
				
				customCommand.setData(returnCommand.toString());
				try {
					agent.invokeCustomCommand(customCommand);
				} catch (InactiveAgentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
			}
		}
	}

	/**
	 * @param service
	 * @return
	 */
	static ITestService getTestService(String service) {
		ITestService serviceImpl = null;

		// Get the service implementation
		IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.hyades.execution.testService", //$NON-NLS-1$
		service);

		if (extension != null) {

			// Retrieve the extension point configuration elements
			IConfigurationElement[] elements = extension.getConfigurationElements();

			// Find the executable extension for application
			try {
				for (int i = 0; i < elements.length; i++) {
					IConfigurationElement element = elements[i];
					if (element.getName().equalsIgnoreCase("testservice")) {
						Object executableExtension = element.createExecutableExtension("class");
						if (executableExtension instanceof ITestService) {
							serviceImpl = (ITestService) executableExtension;
						}
					}
				}
			} catch (CoreException e) {
				// Returning null to indicate unable to acquire service.
			}

		}
		return serviceImpl;
	}

}
