/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAgentControllerDescriptor.java,v 1.1 2005/09/23 15:28:33 sschneid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local.util;

/**
 * The agent controller descriptor interface, abstracts key agent controller
 * metadata such as version
 * 
 * @author Scott E. Schneider
 * @author Joseph P. Toomey
 * @author Bianca Xue Jiang
 */
public interface IAgentControllerDescriptor {

	/**
	 * Retrieves a general property from the agent controller, given the name
	 * and type
	 * 
	 * @param name
	 *            the name of the property such as 'version'
	 * @param type
	 *            the type of the value
	 * @return the property value returned as a string
	 */
	public String getProperty(String name, String type);

	/**
	 * Retrieves the version of the agent controller identified by the node
	 * instance argument
	 * 
	 * @param node
	 *            the node to query for agent controller version information
	 * @return the version of the agent controller
	 */
	public String getVersion();

	/**
	 * Determines if the agent controller version is at least the specified
	 * lower limit inclusive value
	 * 
	 * @param lowerLimitInclusive
	 *            the version is must at least be
	 * @return true if the version is at least the given version
	 */
	public boolean isVersionAtLeast(String lowerLimitInclusive);

	/**
	 * Determines if version is less than or equal to the upper limit inclusive
	 * value
	 * 
	 * @param upperLimitInclusive
	 *            the maximum version
	 * @return true if the version is at most the version specified
	 */
	public boolean isVersionAtMost(String upperLimitInclusive);

	/**
	 * Indicates if the version of the agent controller is exactly equal to the
	 * version passed in as an argument
	 * 
	 * @param version
	 *            the version that the agent controller must match
	 * @return true if the version matches precisely
	 */
	public boolean isVersionEqual(String version);

	/**
	 * Indicates if the version of the agent controller is at least the lower
	 * limit version and at most the upper limit version inclusive
	 * 
	 * @param lowerLimitInclusive
	 *            the minimum version
	 * @param upperLimitInclusive
	 *            the maximum version
	 */
	public boolean isVersionWithin(String lowerLimitInclusive, String upperLimitInclusive);

}
