package org.eclipse.hyades.execution.security;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISecureClientParameters.java,v 1.2 2005/02/25 22:17:09 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.security.Provider;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public interface ISecureClientParameters {
		
	
	public Provider getSecurityProvider();

	public String getKeystoreFileName();
	
	public String getKeystoreFilepassword();
	
	public IKeystoreManager getKeystoreManager();
	
	public String[] getEnabledCipherSuites();
	
	public String[] getEnabledProtocols();
	
	public boolean getRequiresServerAuthentication();
	
	public void disableServerAuthentication();
	
	public void enableServerAuthentication();
	
}