/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: KeystoreHelper.java,v 1.6 2008/03/20 18:49:49 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.security;

/**
 * @author rduggan
 *
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class KeystoreHelper {
	
	
	public static KeyStore createKeyStore(String pathname, String password)
	   throws KeyStoreException,
	           NoSuchAlgorithmException,
	           CertificateException,
	           IOException,
	           NoSuchProviderException  {
	           	
	    KeyStore ks=KeyStore.getInstance("JKS");//$NON-NLS-1$
		
		File file=new File(pathname);
		
		/* Do not stomp an existing file */
		/* bug 197177, handle situation when dat file is of size 0. */
		if(!file.exists() || file.length() == 0) {
			ks.load(null, password.toCharArray());
			persistKeyStore(ks, pathname, password);
		}
		else {
			return loadKeyStore(pathname, password);
		}
		return ks;
	}
	
	public static KeyStore loadKeyStore(String pathname, String password)
	   throws KeyStoreException,
	           NoSuchAlgorithmException,
	           CertificateException,
	           IOException,
	           NoSuchProviderException  {
		
		KeyStore ks=null;
		File file=new File(pathname);
		
		/* Do not stomp an existing file. */
		/* bug 197177.  Add check for file size in case this method is called by others */
		if(file.exists()&& file.length() > 0) {
			ks=KeyStore.getInstance("JKS");//$NON-NLS-1$
			/* Initialize the keystore with no information */
			FileInputStream is=new FileInputStream(file);
			ks.load(is, password.toCharArray());
			is.close();
		}
		return ks;
	}
	
	public static Certificate loadCertificate(String certFilename) 
	   throws CertificateException,
	           FileNotFoundException {
		
		CertificateFactory factory=CertificateFactory.getInstance("X.509");//$NON-NLS-1$
		
		return factory.generateCertificate(new FileInputStream(certFilename));
	}
	
	public static void addCertificateToKeyStore(KeyStore ks, Certificate cert, String alias)
		      throws KeyStoreException {
		ks.setCertificateEntry(alias, cert);
			
	}
	
	public static void persistKeyStore(KeyStore ks, String pathname, String password) 
		throws KeyStoreException,
		        FileNotFoundException,
		        NoSuchAlgorithmException,
		        CertificateException,
		        IOException {
		FileOutputStream os=new FileOutputStream(pathname);
		ks.store(os, password.toCharArray());
		os.close();
		
		
	}
}
