/**********************************************************************
 * Copyright (c) 2006 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: KeystoreManagerImpl.java,v 1.6 2008/03/20 18:49:49 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class KeystoreManagerImpl implements IKeystoreManager {

//	private Provider provider;

	private KeyStore keyStore;

	private X509TrustManagerImpl tm;

	private X509KeyManagerImpl keyManager;

	/**
	 * @see org.eclipse.hyades.collection.framework.security.IKeystoreManager#setKeystoreSpec(java.lang.String, java.lang.String)
	 */
	public void loadKeystore(String filename, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
		boolean isNewKeystore = false;
		KeyManagerFactory keyManagerFactory;
		TrustManagerFactory trustManagerFactory;

		/* The keystore password */
		char[] passphrase = password.toCharArray();

		/* Create our keystore object from the physical keystore */
		keyStore = KeyStore.getInstance("JKS");//$NON-NLS-1$

		/* Check whether the keystore exists */
		File fKeystore = new File(filename);
		if(fKeystore.exists()) {
			keyStore.load(new FileInputStream(filename), passphrase);
		}
		else {
			keyStore.load(null, passphrase);
			isNewKeystore = true;
		}

		/* Setup our factories. */
//		keyManagerFactory = KeyManagerFactory.getInstance("SunX509", provider);
		keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
		keyManagerFactory.init(keyStore, passphrase);

		String algorithm = TrustManagerFactory.getDefaultAlgorithm();
		trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
		trustManagerFactory.init(keyStore);

		tm = new X509TrustManagerImpl(trustManagerFactory);
		keyManager = new X509KeyManagerImpl(keyManagerFactory);

		if(isNewKeystore) {
			FileOutputStream fout = new FileOutputStream(filename);
			keyStore.store(fout, password.toCharArray()); // Bug 141029
			fout.close();
		}
	}

	/**
	 * @see org.eclipse.hyades.collection.framework.security.IKeystoreManager#getKeyManagers()
	 */
	public KeyManager[] getKeyManagers() {
		KeyManager[] kmList = { keyManager };
		return kmList;
	}

	/**
	 * @see org.eclipse.hyades.collection.framework.security.IKeystoreManager#getTrustManagers()
	 */
	public TrustManager[] getTrustManagers() {
		TrustManager[] tmList = { tm };
		return tmList;
	}

	/**
	 * @see org.eclipse.hyades.collection.framework.security.IKeystoreManager#setProvider(java.security.Provider)
	 */
	public void setProvider(Provider provider) {
//		this.provider = provider;
	}
}
