/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SecureClient.java,v 1.6 2008/03/20 18:49:49 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.security;


import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

import org.eclipse.hyades.execution.local.internal.resources.LocalResourceBundle;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public final class SecureClient {
	private SSLSocket sslsocket;

	private IKeystoreManager loadKeystore(ISecureClientParameters params) 
		 throws java.security.KeyStoreException, 
		        java.security.NoSuchAlgorithmException,
		        java.security.UnrecoverableKeyException,
		        java.security.KeyManagementException,
		        java.security.cert.CertificateException,
		        java.io.IOException
	{
		IKeystoreManager manager=params.getKeystoreManager();
//		manager.setProvider(params.getSecurityProvider());
		manager.loadKeystore(params.getKeystoreFileName(), params.getKeystoreFilepassword()); 
		return manager;
	}


	public void init(ISecureClientParameters params, String host, int port) 
		throws java.security.KeyStoreException, 
				java.security.NoSuchAlgorithmException,
				java.security.UnrecoverableKeyException,
				java.security.KeyManagementException,
				java.security.cert.CertificateException,
				java.io.IOException{
		int protocolOffset = 0;
		IKeystoreManager keyManager=null;
		
		/* add the proper security provider */
//		Security.addProvider(params.getSecurityProvider());
		
		
		/* Load our keystore */
		keyManager=loadKeystore(params);
		
		
		/* Setup our SSLContext */
		SSLContext sslContext=null;
		String[] sslProtocols = params.getEnabledProtocols();
		do {
		
			try {
				sslContext=SSLContext.getInstance(sslProtocols[protocolOffset]/*, params.getSecurityProvider()*/);
				break;
			}
			catch(NoSuchAlgorithmException e) {
				protocolOffset++;
				if(protocolOffset==sslProtocols.length) {
					throw e;		
				}		
			}		
		}while(protocolOffset<sslProtocols.length);
			
		/* Initailize our context with the specified key and trust managers */
		sslContext.init(keyManager.getKeyManagers(), keyManager.getTrustManagers(), null);

		
		/* Create out Secure socket to connect to server on the specified host and port. */
		sslsocket=(SSLSocket)sslContext.getSocketFactory().createSocket(host, port);
		

		/* Use the cypher suites specified */
		sslsocket.setEnabledCipherSuites(params.getEnabledCipherSuites());
		
		/* Start the handshake with the server */
        sslsocket.startHandshake();
        
        /* Get the sesson to ensure the connection is complete */
        SSLSession session = sslsocket.getSession();	
		if (session == null) {
			System.out.println(LocalResourceBundle.SecureClient_SESSION_NULL_CONNETCION_FAILED_);
			throw new IOException(LocalResourceBundle.SecureClient_NO_SOCKET_SESSION_CREATED_);
		}
	}

	public SSLSocket getSocket() {
		return sslsocket;
	}
	
}