/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: User.java,v 1.2 2007/08/21 12:50:06 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.security;

import java.io.IOException;
import java.security.Principal;

import org.eclipse.hyades.execution.core.util.Noop;
import org.eclipse.hyades.execution.local.common.AuthenticateCommand;
import org.eclipse.hyades.execution.local.common.CommandElement;
import org.eclipse.hyades.execution.local.common.Constants;
import org.eclipse.hyades.execution.local.common.ControlMessage;
import org.eclipse.hyades.execution.local.control.Application;
import org.eclipse.hyades.execution.local.control.CommandHandler;
import org.eclipse.hyades.execution.local.control.Connection;
import org.eclipse.hyades.execution.local.control.Node;

public class User implements Principal, CommandHandler {

	private String _name;
	private String _password;
	private Application _app;
	private String _alias;
	private boolean _isPasswordEncrypted;

	{
		Noop.sink(this._alias, this._isPasswordEncrypted);
	}

	public static final boolean ENABLE_PASSWORD_ENCRYPTION = false;

	public User(Application app, String name, String password) {
		_app = app;
		_name = name;
		setPassword(password);
	}

	/**
	 * @see java.security.Principal#getName()
	 */
	public String getName() {
		return _name;
	}

	public void setPassword(String password) {
		/*
		 * Try and store the passowrd in memory encrypted. If we fail to encrypt
		 * the password we will store it as is.
		 */
		try {
			if (ENABLE_PASSWORD_ENCRYPTION) {
				// _password=ISecurityUtilityImpl.PasswordUtil.encode(password);
				_isPasswordEncrypted = true;
			} else {
				throw new RuntimeException();
			}
		} catch (Exception e) {
			_password = password;
			_isPasswordEncrypted = false;
		}

	}

	public Application getApplication() {
		return _app;
	}

	public void login(Connection connection) throws IOException {
		login(connection, this);
	}

	public void login(Connection connection, CommandHandler handler) throws IOException {

		ControlMessage message = new ControlMessage();
		AuthenticateCommand command = null;
		;

		String decryptedPassword = null;
		try {

			if (ENABLE_PASSWORD_ENCRYPTION) {
				// decryptedPassword=ISecurityUtilityImpl.PasswordUtil.decode(_password);
			} else {
				throw new RuntimeException();
			}
		} catch (Exception e) {
			decryptedPassword = _password;
		}
		command = new AuthenticateCommand(_name, decryptedPassword);
		message.appendCommand(command);
		connection.sendMessage(message, handler);
	}

	public void incommingCommand(Node node, CommandElement command) {
		switch ((int) command.getTag()) {
		case (int) Constants.RA_AUTHENTICATION_SUCCESSFUL:
			break;
		case (int) Constants.RA_AUTHENTICATION_FAILED:
			break;
		}
	}
}
