/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: X509KeyManagerImpl.java,v 1.1 2006/03/13 20:47:13 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.security;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public class X509KeyManagerImpl implements X509KeyManager {
	private KeyManager kmList[] = null;

	private X509KeyManager km = null;

	private String clientAlias = null;

	private String serverAlias = null;

	public X509KeyManagerImpl(KeyManagerFactory kmf) {
		kmList = kmf.getKeyManagers();

		if (kmList != null) {
			km = (X509KeyManager) kmList[0];
		}
	}

	/**
	 * @see javax.net.ssl.X509KeyManager#getPrivateKey(java.lang.String)
	 */
	public PrivateKey getPrivateKey(String s) {
		return km.getPrivateKey(s);
	}

	/**
	 * @see javax.net.ssl.X509KeyManager#getCertificateChain(java.lang.String)
	 */
	public X509Certificate[] getCertificateChain(String s) {
		return km.getCertificateChain(s);
	}

	/**
	 * @see javax.net.ssl.X509KeyManager#getClientAliases(java.lang.String, java.security.Principal[])
	 */
	public String[] getClientAliases(String keyType, Principal[] issuers) {
		return km.getClientAliases(keyType, issuers);
	}

	/**
	 * @see javax.net.ssl.X509KeyManager#getServerAliases(java.lang.String, java.security.Principal[])
	 */
	public String[] getServerAliases(String keyType, Principal[] issuers) {
		return km.getServerAliases(keyType, issuers);
	}

	/**
	 * @see javax.net.ssl.X509KeyManager#chooseServerAlias(java.lang.String, java.security.Principal[], java.net.Socket)
	 */
	public String chooseServerAlias(String keyType, Principal[] issuers,
			Socket sock) {
		if (serverAlias != null && !serverAlias.equals("")) {
			String[] list = km.getServerAliases(keyType, issuers);
			String aliases = "";

			if (list != null) {
				for (int i = 0; i < list.length; i++) {
					aliases += list[i] + " ";
					if (serverAlias.equalsIgnoreCase(list[i])) {
						return serverAlias;
					}

				}
			}

			return serverAlias;
		} else {
			return km.chooseServerAlias(keyType, issuers, sock);
		}
	}

	/**
	 * @see javax.net.ssl.X509KeyManager#chooseClientAlias(java.lang.String[], java.security.Principal[], java.net.Socket)
	 */
	public String chooseClientAlias(String[] keyType, Principal[] issuers,
			Socket sock) {
		if (clientAlias != null && !clientAlias.equals("")) {
			String[] list = km.getClientAliases(keyType[0], issuers);
			String aliases = "";

			if (list != null) {
				for (int i = 0; i < list.length; i++) {
					aliases += list[i] + " ";
					if (clientAlias.equalsIgnoreCase(list[i])) {
						return clientAlias;
					}
				}
			}

			// error case, alias not found in the list.
			return clientAlias;
		} else {
			return km.chooseClientAlias(keyType, issuers, null);
		}
	}
}
