/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: X509TrustManagerImpl.java,v 1.1 2006/03/13 20:47:13 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.security;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerImpl implements X509TrustManager {

	boolean serverAuthenticationEnabled = true;

	private X509TrustManager delegate;

	private X509Certificate[] receivedCerts;

	private X509Certificate[] certs;

	public X509TrustManagerImpl(TrustManagerFactory factory) {
		TrustManager[] managers = factory.getTrustManagers();
		for (int i = 0; i < managers.length; i++) {
			if (managers[i] instanceof X509TrustManager) {
				delegate = (X509TrustManager) managers[i];
				certs = ((X509TrustManager) managers[i]).getAcceptedIssuers();
				break;
			}
		}
		if (delegate == null) {
			certs = new X509Certificate[] {};
		}
	}

	public X509Certificate[] getReceivedCerts() {
		return this.receivedCerts;
	}

	/**
	 * @see javax.net.ssl.X509TrustManager#getAcceptedIssuers()
	 */
	public X509Certificate[] getAcceptedIssuers() {
		return certs;
	}

	/**
	 * @see javax.net.ssl.X509TrustManager#checkClientTrusted(java.security.cert.X509Certificate[],
	 *      java.lang.String)
	 */
	public void checkClientTrusted(X509Certificate[] cert, String authType)
	throws CertificateException {

	}

	/**
	 * @see javax.net.ssl.X509TrustManager#checkServerTrusted(java.security.cert.X509Certificate[],
	 *      java.lang.String)
	 */
	public void checkServerTrusted(X509Certificate[] cert, String authType)
	throws CertificateException {

		/* If server authentication is on then we will reject the connection */
		if (serverAuthenticationEnabled) {
			receivedCerts = cert;
			if (delegate != null) {
				delegate.checkServerTrusted(cert, authType);
			} else {
				throw new CertificateException();
			}
		}
	}

	/**
	 * 
	 */
	public void disableServerAuthentication() {
		serverAuthenticationEnabled = false;
	}

	/**
	 * 
	 */
	public void enableServerAuthentication() {
		serverAuthenticationEnabled = true;
	}
}
