/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFileConnectionHandler.java,v 1.3 2005/05/20 22:53:09 jptoomey Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.file;

import java.net.Socket;

import org.eclipse.hyades.execution.security.IConnectionHandler;

/**
 * @author Giridhar.S
 * 
 * A connection handler class for file transfer.
 *
 */
public interface IFileConnectionHandler extends IConnectionHandler {
	
	/**
	 * A method which accepts the connected socket, and performs required operations 
	 * on the parameters passed.
	 *  
	 * @param s
	 * @param operation
	 * @param fileName
	 */
	public void connectionAccepted (Socket s, long operation, String fileName);
}
