/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IFileServer.java,v 1.4 2005/05/20 22:53:09 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.file;

/**
 * Interface that all implementations of the file server will implement
 * 
 * @author Scott E. Schneider
 */
public interface IFileServer {

	/**
	 * Returned the error type of the last error condition that was triggered in
	 * the file server
	 * 
	 * @return refer to the file service constants for the various return codes
	 *         that are valid
	 */
	public int getErrorType();

	/**
	 * Returns the current status of the file server
	 * 
	 * @return refer to the file service constants for the various return codes
	 *         that are valid
	 */
	public int getFileServerStatus();

	/**
	 * Initialize the file server with the specified file server parameters,
	 * this is where the port and connection handler are specified
	 * 
	 * @param parameters
	 *            the various parameters needed to configure the file server at
	 *            run-time
	 */
	public void init(IFileServerParameters parameters);

	/**
	 * Request that the file server is shutdown
	 */
	public void quit();

	/**
	 * Run the file server and begin accepting connections on the port specified
	 * by the file server parameters
	 */
	public void run();

}
