/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentConfigurationCommand.java,v 1.3 2006/03/06 19:49:40 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;

import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;

public class AgentConfigurationCommand extends CommandElement implements Constants {
	private long processId = 0;
	private RAString processUUID = new RAString();
	private RAString agentName = new RAString();
	private RAString agentUUID = new RAString();
	private RAString agentType = new RAString();
	private RAString nodeUUID = new RAString();
	private Vector entries = new Vector();

	public AgentConfigurationCommand() {
		_tag = Constants.RA_AGENT_CONFIGURATION;
	}

	public int getSize() {
		int size = 0;

		size += super.getSize();

		size += sizeofLong; // processId

		size += processUUID.getSize();
		size += agentName.getSize();
		size += agentUUID.getSize();
		size += agentType.getSize();
		size += nodeUUID.getSize();

		size += sizeofLong; // num of entries
		for(int i = 0; i < entries.size(); i++) {
			RAString name = new RAString(((AgentConfigurationEntry)entries.elementAt(i)).getName());
			RAString type = new RAString(((AgentConfigurationEntry)entries.elementAt(i)).getType());
			RAString value = new RAString(((AgentConfigurationEntry)entries.elementAt(i)).getValue());

			size += name.getSize();
			size += type.getSize();
			size += value.getSize();
		}

		return size;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;
		long numConfig;

		current = super.readFromBuffer(buffer, current);

		processId = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		current = Message.readRAStringFromBuffer(buffer, current, processUUID);
		current = Message.readRAStringFromBuffer(buffer, current, agentName);
		current = Message.readRAStringFromBuffer(buffer, current, agentUUID);
		current = Message.readRAStringFromBuffer(buffer, current, agentType);
		current = Message.readRAStringFromBuffer(buffer, current, nodeUUID);

		numConfig = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		for(int i = 0; i < numConfig; i++) {
			RAString type = new RAString();
			RAString name = new RAString();
			RAString value = new RAString();

			current = Message.readRAStringFromBuffer(buffer, current, type);
			current = Message.readRAStringFromBuffer(buffer, current, name);
			current = Message.readRAStringFromBuffer(buffer, current, value);

			AgentConfigurationEntry entry = new AgentConfigurationEntry();
			entry.setType(type.getData());
			entry.setName(name.getData());
			entry.setValue(value.getData());

			addEntry(entry);
		}

		return current;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = super.writeToBuffer(buffer, current);
		current = Message.writeRALongToBuffer(buffer, current, processId);
		current = Message.writeRAStringToBuffer(buffer, current, processUUID);
		current = Message.writeRAStringToBuffer(buffer, current, agentName);
		current = Message.writeRAStringToBuffer(buffer, current, agentUUID);
		current = Message.writeRAStringToBuffer(buffer, current, agentType);
		current = Message.writeRAStringToBuffer(buffer, current, nodeUUID);
		current = Message.writeRALongToBuffer(buffer, current, entries.size());
		for(int i = 0; i < entries.size(); i++) {
			AgentConfigurationEntry entry = (AgentConfigurationEntry)entries.elementAt(i);
			current = Message.writeRAStringToBuffer(buffer, current, new RAString(entry.getType()));
			current = Message.writeRAStringToBuffer(buffer, current, new RAString(entry.getName()));
			current = Message.writeRAStringToBuffer(buffer, current, new RAString(entry.getValue()));
		}

		return current;
	}

	public void clear() {
		entries.clear();
	}

	public AgentConfigurationEntry[] getConfigurations() {
		return (AgentConfigurationEntry[])entries.toArray();
	}

	public void addEntry(AgentConfigurationEntry entry) {
		this.entries.add(entry);
	}

	public boolean removeEntry(AgentConfigurationEntry entry) {
		if(entries.contains(entry)) {
			entries.remove(entry);
			return true;
		}
		else {
			return false;
		}
	}

	public RAString getAgentName() {
		return agentName;
	}

	public void setAgentName(RAString agentName) {
		this.agentName = agentName;
	}

	public RAString getAgentType() {
		return agentType;
	}

	public void setAgentType(RAString agentType) {
		this.agentType = agentType;
	}

	public RAString getAgentUUID() {
		return agentUUID;
	}

	public void setAgentUUID(RAString agentUUID) {
		this.agentUUID = agentUUID;
	}

	public RAString getNodeUUID() {
		return nodeUUID;
	}

	public void setNodeUUID(RAString nodeUUID) {
		this.nodeUUID = nodeUUID;
	}

	public long getProcessId() {
		return processId;
	}

	public void setProcessId(long processId) {
		this.processId = processId;
	}

	public RAString getProcessUUID() {
		return processUUID;
	}

	public void setProcessUUID(RAString processUUID) {
		this.processUUID = processUUID;
	}

}
