/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AuthenticationFailedCommand.java,v 1.4 2006/04/06 15:28:00 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class AuthenticationFailedCommand extends CommandElement implements Constants {
	private long _ticket;

	public AuthenticationFailedCommand() {
		super();
		_tag = RA_AUTHENTICATION_FAILED;
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#getSize()
	 */
	public int getSize() {
		int size = super.getSize();

		size += sizeofLong;

		return size;
	}

	public long getTicket() {
		return _ticket;
	}
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current = offset;

		/*
		 * Cannot call super.readFromBuffer() since this command does not have a context
		 */
//		current = super.readFromBuffer(buffer, current);
		_ticket = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;

		return current;
	}

	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		/*
		 * Cannot call super.writeToBuffer() since this command does not have a context
		 */
//		current = super.writeToBuffer(buffer, current);
		current = Message.writeRALongToBuffer(buffer, current, _tag);
		current = Message.writeRALongToBuffer(buffer, current, _ticket);

		return current;
	}

}
