/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommandElement.java,v 1.4 2006/04/06 15:28:00 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

public abstract class CommandElement implements Constants {
	
	protected long _tag = 0;
	protected long _context = 0;

	public CommandElement() {
		super();
	}

	/**
	 * Return the context of this command element
	 * @return context
	 */
	public long getContext() {
		return _context;
	}

	/**
	 * Return the size of this command in number of bytes
	 * @return size
	 */
	public int getSize() {
		return 2 * sizeofLong;
	}

	/**
	 * Return the command tag
	 * @return tag
	 */
	public long getTag() {
		return _tag;
	}

	/**
	 * Construct the command by reading the buffer
	 * @param buffer Buffer containing serialized command
	 * @param offset Start position for reading
	 * @return
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		/* Do not need to read the tag since it is already read before coming in here */
		int current = offset;
		_context = Message.readRALongFromBuffer(buffer, current);
		current += sizeofLong;
		return current;
	}

	/**
	 * Set the command's context
	 * @param context
	 */
	public void setContext(long context) {
		_context = context;
	}

	/**
	 * Serialize the command into the byte buffer
	 * @param buffer Buffer containing serialized command
	 * @param offset Start position for reading
	 * @return
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current = offset;

		current = Message.writeRALongToBuffer(buffer, current, _tag);
		current = Message.writeRALongToBuffer(buffer, current, _context);

		return current;
	}
	
}
