/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConsoleInfoCommand.java,v 1.4 2006/04/06 15:28:00 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.io.InputStream;
import java.io.OutputStream;

public class ConsoleInfoCommand extends SimpleProcessCommand {
	private InputStream _stdout;
	private InputStream _stderr;
	private OutputStream _stdin;

	public ConsoleInfoCommand(long pid, InputStream stdout, InputStream stderr, OutputStream stdin) {
		_tag = Constants.RA_CONSOLE_INFO;
		_stdout = stdout;
		_stderr = stderr;
		_stdin = stdin;
		super.setProcessId(pid);
	}

	public long getProcessId() {
		return super.getProcessId();
	}

	public InputStream getStdOut() {
		return _stdout;
	}

	public InputStream getStdErr() {
		return _stderr;
	}

	public OutputStream getStdIn() {
		return _stdin;
	}

	public int getSize() {
		return 0;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		return 0;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		return 0;
	}

}
