/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Constants.java,v 1.10 2008/03/20 18:49:50 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (6/2/00 1:15:33 PM)
 * @author: Administrator
 */
public interface Constants {
	public static int DEFAULT_TIMEOUT = 10000;

	public static final String RA_MASTER_ADDRESS			= "ramaster";//$NON-NLS-1$
	public static final String RA_PIPE_NAMESPACE			= "IBMRAC";//$NON-NLS-1$
	public static final String RA_PIPE_NAMESPACE_WIN32		= "IBMAC";//$NON-NLS-1$

	/* Various Message types currently available */
	public static final byte RA_ACKNOWLEDGEMENT_MESSAGE			=0x00000000;
	public static final byte RA_CONTROL_MESSAGE					=0x00000001;

	public final static long RA_MAGIC						=0x82656780;
	public final static byte RA_MAGIC_0						=(byte)(RA_MAGIC >> 24 & 0xff);
	public final static byte RA_MAGIC_1						=(byte)(RA_MAGIC >> 16 & 0xff);
	public final static byte RA_MAGIC_2						=(byte)(RA_MAGIC >> 8 & 0xff);
	public final static byte RA_MAGIC_3						=(byte)(RA_MAGIC & 0xff);
	
	public final static long RA_VERSION						=0x00000100;

	public final static long RA_AUTHENTICATE					=0x00000001;
	public final static long RA_AUTHENTICATION_FAILED			=0x00000002;
	public final static long RA_AUTHENTICATION_SUCCESSFUL		=0x00000003;
	public final static long RA_SERVER_SECURITY_REQUIREMENTS	=0x00000004;
	public final static long RA_LAUNCH_PROCESS					=0x00000010;
	public final static long RA_QUERY_PROCESS_LIST				=0x00000011;
	public final static long RA_QUERY_AGENT_LIST				=0x00000012;
	public final static long RA_REGISTER_AGENT_NOTIFICATION		=0x00000013;
	public final static long RA_ATTACH_TO_AGENT					=0x00000014;
	public final static long RA_DETACH_FROM_AGENT				=0x00000015;
	public final static long RA_START_MONITORING_AGENT_REMOTE	=0x00000016;
	public final static long RA_START_MONITORING_AGENT_LOCAL	=0x00000017;
	public final static long RA_STOP_MONITORING_AGENT			=0x00000018;
	public final static long RA_SET_NAME_VALUE_PAIR				=0x00000019;
	public final static long RA_CUSTOM_COMMAND					=0x0000001A;
	public final static long RA_KILL_PROCESS					=0x0000001B;
	public final static long RA_QUERY_AGENT_DETAILS				=0x0000001C;
    public final static long RA_BINARY_CUSTOM_COMMAND			=0x0000001D;
	public final static long RA_GET_PROPERTY_LIST				=0x0000001E;
	public final static long RA_MANAGE_FILE						=0x0000001F;
	public final static long RA_PROCESS_LAUNCHED				=0x00000020;
	public final static long RA_PROCESS_LIST					=0x00000021;
	public final static long RA_AGENT_LIST						=0x00000022;
	public final static long RA_AGENT_ACTIVE					=0x00000023;
	public final static long RA_AGENT_INACTIVE					=0x00000024;
	public final static long RA_ERROR_STRING					=0x00000025;
	public final static long RA_ATTACH_SUCCESSFUL				=0x00000026; // Not used
	public final static long RA_ATTACH_FAILED					=0x00000027; // Not used
	public final static long RA_AGENT_DETAILS					=0x00000028;
	public final static long RA_PROCESS_EXITED					=0x00000029;
	public final static long RA_PROPERTY_LIST					=0x0000002A;
	public final static long RA_AGENT_QUERY_STATE				=0x0000002B;
	public final static long RA_AGENT_ATTACHED					=0x0000002C;
	public final static long RA_AGENT_DETACHED					=0x0000002D;
	public final static long RA_LOCAL_AGENT_ACTIVE				=0x00000030; // Not used
	public final static long RA_AGENT_SCOPING_INFORMATION		=0x00000031;
	public final static long RA_AGENT_CONFIGURATION				=0x00000032;
	public final static long RA_AGENT_CONTROLLER_AVAILABLE		=0x00000050; // Not used
	public final static long RA_AGENT_CONTROLLER_UNAVAILABLE	=0x00000051; // Not used
	public final static long RA_AGENT_REQUEST_MONITOR			=0x00000061;
	public final static long RA_CONTROLLER_REQUEST_MONITOR		=0x00000062;
	public final static long RA_PEER_UNREACHABLE				=0x00000063;
	public final static long RA_CONTROLLER_MONITOR_PEER			=0x00000064; // Not used
	public final static long RA_AGENT_REQUEST_MONITOR_PORT		=0x00000065;
	public final static long RA_CONTROLLER_REQUEST_MONITOR_PORT	=0x00000066;
	public final static long RA_RESOURCE_LOCATION				=0x00000070;
	public final static long RA_CONSOLE_INFO					=0x00000080;
	public final static long RA_SHUTDOWN						=0x000000FF;

	public final static long RA_GET_FILE						=0x00000001;
	public final static long RA_PUT_FILE						=0x00000002;
	public final static long RA_DELETE_FILE						=0x00000003;

	/**
 	  * Various constants that both the client and server must adhere to.
 	  */
	public final static int CTL_PORT_NUM_SERVER			=10002; /* hardcoded to start with */
	public final static int CTL_PORT_NUM_CLIENT			=10003; /* hardcoded to start with */
	public final static int MESSAGE_HEADER_LENGTH		=10;		/* 10 byte header to start with */
	public final static int MAX_MESSAGE_LENGTH			=8096;	/* The maximum size of a message */
	public final static int MAX_COMMAND_LINE_LENGTH		=512;	/* Maximum length of a command line string */
	public final static int DATA_PORT_NUM_CLIENT		=10004;
	public final static int MAX_DATA_LENGTH				=4096;	/* The size of the data buffer for sockets */

	/* This package is ported from C, so to facilitate sizeof code for primitives
	   the following constants are provided */

	public final static int sizeofByte					=1;
	public static final int sizeofChar					=2;
	public static final int sizeofShort					=2;
	public static final int	sizeofLong					=4;


	
	
}
