/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExtendedDataServerListener.java,v 1.2 2005/09/30 21:45:08 slavescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.io.InputStream;

/**
 * @author slavescu
 */
public interface ExtendedDataServerListener extends DataServerListener {
	/**
	 * @param buffer byte[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 */
	void incommingData(byte[] buffer, int offset, int length, java.net.InetAddress peer);
	/**
	 * @param buffer char[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 */
	void incommingData(char[] buffer, int offset, int length, java.net.InetAddress peer);
	/**
	 * @param data byte[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 */
	void invalidDataType(byte[] data, int offset, int length, java.net.InetAddress peer);

	void incommingStream(InputStream inputStream, java.net.InetAddress peer);
}
